﻿using System.Configuration;

namespace Ucilica
{
    public class RepoFactory
    {
        public static IRepository GetInstance()
        {
            int type = int.Parse(ConfigurationManager.AppSettings["repoType"]);

            switch (type)
            {
                case 1:
                    return new File1RepoImplementation();
                case 2:
                    return new File2RepoImplementation();
                case 3:
                    return new SQLRepoImplementation();
                default:
                    return null;
            }
        }
    }
}
