﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using TrelloRepo;
using TrelloRepo.Model;

namespace ConcoleKlijent
{
    internal class Program
    {
        private static readonly IRepository repository = RepositoryFactory.GetRepository();
        static void Main(string[] args)
        {
            FillItems();
            ReadItems();
            Console.WriteLine();
            ReadUsers();
            Console.WriteLine();
            ReadSingleUser();
        }

        private static void ReadSingleUser() => Console.WriteLine(repository.GetUser(1));

        private static void ReadUsers()=>repository.GetUsers().ToList().ForEach(Console.WriteLine);

        private static void ReadItems()=>repository.GetItems().ToList().ForEach(Console.WriteLine);

        private static void FillItems()
        {
            repository.AddItem(
                new Item
                {
                    Datum = DateTime.Now.AddDays(-2),
                    Opis = "Prvi",
                    Id = 1,
                    User = new User
                    {
                        Id = 1,
                        Ime = "Ana",
                        Prezime = "Anic"
                    }
                }
                );
            repository.AddItem(
                new Item
                {
                    Datum = DateTime.Now,
                    Opis = "Drugi item",
                    Id = 2,
                    User = new User
                    {
                        Id = 2,
                        Ime = "Marko",
                        Prezime = "Maric"
                    }
                }
                );
            repository.AddItem(
                new Item
                {
                    Datum = DateTime.Now.AddDays(2),
                    Opis = "Treci item",
                    Id = 3,
                    User = new User
                    {
                        Id = 3,
                        Ime = "Ivo",
                        Prezime = "Ivic"
                    }
                }
                );
        }
    }
}
