﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Zadatak
{
    public static class PizzaFactory
    {
        private const string CONFIG_PATH = "pizza-config.txt";

        public static Pizza Create(string name)
        {
            Pizza pizza;

            switch (name)
            {
                //case "Capricciosa":
                case nameof(Capricciosa):
                    pizza = new Capricciosa();
                    break;
                case nameof(Margherita):
                    pizza = new Margherita();
                    break;
                default:
                    throw new Exception("There is no such pizza!");
            }

            CompletePizza(pizza);

            return pizza;
        }

        public static Pizza Create(PizzaType type)
        {
            Pizza pizza = null;

            switch (type)
            {
                case PizzaType.Capricciosa:
                    pizza = new Capricciosa();
                    break;
                case PizzaType.Margherita:
                    pizza = new Margherita();
                    break;
            }

            CompletePizza(pizza);

            return pizza;
        }

        public static Pizza CreateByFullClassName(string fullClassName)
        {
            // Type kreiramo preko punog naziva klase
            Type type = Type.GetType(fullClassName);

            // koristeci reflection kreiramo novi objekt preko Typea
            Pizza pizza = Activator.CreateInstance(type) as Pizza;

            CompletePizza(pizza);
            return pizza;
        }

        private static void CompletePizza(Pizza pizza)
        {
            pizza.Prepare();
            pizza.Bake();
            pizza.Serve();
            pizza.Charge();
        }

        public static Pizza CreateFromConfig()
        {
            string fullClassName = File.ReadAllText(CONFIG_PATH);
            return CreateByFullClassName(fullClassName);
        }
    }
}
