﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Zadatak03
{
    internal class Program
    {
        static void Main(string[] args)
        {
            AvoidExceptions();
            ImitateTryParse();
        }

        private static void ImitateTryParse()
        {
            int outValue;
            do 
            {
                Console.WriteLine("Broj:");
            } while (!TryParse(Console.ReadLine(),out outValue));
            Console.WriteLine(outValue);
        }

        private static bool TryParse(string text, out int value)
        {
            try
            {
                value = int.Parse(text);
                return true;
            }
            catch (Exception e) when ( //exception filter
                e is ArgumentException ||
                e is FormatException ||
                e is OverflowException)
            {
                value = 0;
                //out parameter koji mora biti inutar takve metode
            }
            return false;

        }

        private static void AvoidExceptions()
        {
            //PROBLEM: 2 exptions
            string test = null; //NullRefernceException;
            test = ""; //IndexOutOfRangeException;
            //Console.WriteLine(test.ToLower()[0]);

            //RJEŠENJE
            //1 ručno handlanje svih problema
            if (test != null && test.Length > 0)
            {
                Console.WriteLine(test.ToLower()[0]);
            }

            //2 ternary - imamo defaultnu vrijednost ukoliko nešto nije ispravno
            test=test!=null && test.Length > 0?test:"default";
            test= !string.IsNullOrEmpty(test)?test:"default";
            Console.WriteLine(test.ToLower()[0]);

            //3 null coalescing oprator - "ako oprator je non-null, daj mi ga, inače
            // vrati mi default vrijednost
            //također on handla samo NullRefernceException
            test = test ?? "milica";
            Console.WriteLine(test.ToLower()[0]);

            //4 null conditional oprator - C# u ELVIS
            //samo NullReferncesException
            Console.WriteLine(test?.ToLower()[0]);
            Console.WriteLine(test?[0]);
        }
    }
}
