﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using System.Text;
using System.Threading.Tasks;

namespace Zadatak01
{
    internal class Program
    {
        static void Main(string[] args)
        {
            double a = 5.5;
            double b = 7.7;

            // delegatu MathOperation pridodijelimo referencu na metodu
            MathOperation mathOperation = Add;

            // duzi poziv koristeci Invoke
            double result = mathOperation.Invoke(a, b);
            Console.WriteLine($"{a} + {b} = {result}");

            mathOperation = Subtract;
            // kraci poziv bez Invokea
            Console.WriteLine($"{a} - {b} = {mathOperation(a, b)}");

            mathOperation = Math.Pow;
            Console.WriteLine($"{a} ^ {b} = {mathOperation(a, b)}");

            result = PerformMathOperation(a, b, Multiply);
            Console.WriteLine($"{a} * {b} = {result}");

            // predajemo lambda "=>" funkciju
            result = PerformMathOperation(a, b, (x, y) =>  x / y);
            Console.WriteLine($"{a} / {b} = {result}");

            // ===================================
            // Koristenje ugradjenog Func delegata
            Func<double, double, double> funcMathOperation = Add;
            Console.WriteLine($"{a} + {b} = {funcMathOperation(a, b)}");

            funcMathOperation = Math.Pow;
            Console.WriteLine($"{a} ^ {b} = {funcMathOperation(a, b)}");

            // ne moze se kompajlirati jer nije isti tip delegata
            //result = PerformMathOperation(a, b, funcMathOperation);

            Console.WriteLine();

            MathOperation multicastMathOperation = Add;
            multicastMathOperation += Subtract;

            // razlog zasto ne vidimo oba poziva je taj sto MathOperation vraca vrijednost,
            // a kod multicast delegata,
            // vrijednost koja se vraca iz posljednje metode na listi je
            // ta koja se propagira natrag pozivatelju
            //Console.WriteLine(multicastMathOperation(a, b));

            foreach (var method in multicastMathOperation.GetInvocationList())
            {
                result = (double)method.DynamicInvoke(a, b);
                Console.WriteLine($"Result multicast: {result}");
            }
        }

        private static double Multiply(double x, double y)
        {
            return x * y;
        }

        private static double PerformMathOperation(double x, double y,
            MathOperation mathOperation)
        {
            return mathOperation(x, y);
        }

        private static double Subtract(double x, double y)
        {
            return x - y;
        }

        private static double Add(double x, double y)
        {
            return x + y;
        }

        private delegate double MathOperation(double x, double y);
    }
}
