﻿using CleanCode.Model;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace CleanCode
{
    internal class Program
    {
        static void Main(string[] args)
        {
            List<Student> list = new List<Student>();
            Student student = new Student("Ana", "Anic", Student.StudentTip.Redovni);
            list.Add(student);
            Console.WriteLine($"Equals: {student.Equals(list[0])}");

            Student student1 = new Student("Ivo", "Ivic", Student.StudentTip.Izvanredni);
            list.Add(student1);
            Student student2 = new Student("Miro", "Miric", Student.StudentTip.Redovni);
            list.Add(student2);

            Console.WriteLine("Ispis studenata nesortiran: ");
            list.ForEach(Console.WriteLine);

            Console.WriteLine("Studenti sortirani po ID-u:");
            list.Sort();
            list.ForEach(Console.WriteLine);


            Console.WriteLine("Studenti sortirani po prezimenu:");
            list.Sort(new StudentPrezimeASC());
            list.Sort((x, y) => x.Prezime.CompareTo(y.Prezime));
            list.ForEach(Console.WriteLine);

            Console.WriteLine("-----------------------------------");
            Predmet predmet = new Predmet
            {
                Code = "123",
                ECTS = 25,
                Naziv = "OOP"
            };
            //Predmet predmet1 = new Predmet
            //{ 
            //    Code="1234",
            //    ECTS=10,
            //    Naziv="Programiranje"
            //};

            Console.WriteLine(predmet);
            //Console.WriteLine(predmet1);

            Console.WriteLine("-----------------------------------");
            Console.WriteLine("Profesori");
            Profesor profesor = new Profesor("Profesor", "Profesoric", predmet);
            Profesor asistent = new Profesor("Asistent", "Asistentic", predmet);
            Console.WriteLine(profesor);
            Console.WriteLine(asistent);

            Console.WriteLine("------------------------------------)");
            Console.WriteLine("Dekan");
            Dekan dekan = new Dekan("Dekan", "Ivic", "dekan");
            Console.WriteLine(dekan);

            List<Osoba> osobe = new List<Osoba>
            {
                student,
                student1,
                student2,
                asistent,
                profesor,
                dekan
            };

            Console.WriteLine($"Broj svih osoba: {osobe.Count}");
            Console.WriteLine("----------------------------------");
            Console.WriteLine("Dokument");
            Dokument dokument = new Dokument
            {
                Naslov = "Naslov dokumenta",
                Text = "Text dokumenta"
            };
            Console.WriteLine(dokument);

            Console.WriteLine("-------------------------------------");
            Console.WriteLine("Potpisivanje");
            List<ISignable> listToSign = new List<ISignable>
            { 
                predmet,
                dokument
            };
            listToSign.ForEach(dekan.GiveSign);
            listToSign.ForEach(Console.WriteLine);
        }
    }
}
