﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Zadatak.Rjesenje;

namespace Zadatak
{
    internal class Program
    {
        static void Main(string[] args)
        {
            //PrikazProblema();
            PrikazRjesenja();
        }

        private static void PrikazRjesenja()
        {
            //Klijent
            //1.) naručiti pizzu
            //2.) uziva u pizzi
            Pizza margarita = Rjesenje.PizzaFactory.GetPizza("Margherita");
            Console.WriteLine($"Uzivam u : {margarita}");
            Console.WriteLine();

            //dodavanje nove pizze:
            //1) napravimo novu klasu za novu pizzu
            //2) promjena koda PizzaFactory i dodavanje novog case bloka
            Pizza vegeratiana = PizzaFactory.GetPizza("Vegetariana");
            Console.WriteLine($"Uzivam u: {vegeratiana}");
            Console.WriteLine();

            Pizza mjesana=PizzaFactory.GetPizzaByReflection(typeof(Capricciosa).FullName);
            Console.WriteLine($"Uzivam u: {mjesana}");
            Console.WriteLine();

            //dodavanje nove pizze upotrebom Reflectiona su:
            //1) kreiram novu klasu
            //2) i to je to!!
            Pizza slavonska=PizzaFactory.GetPizzaByReflection(typeof (Slavonska).FullName);
            Console.WriteLine($"uzivam u: {slavonska}");
            Console.WriteLine();
        }

        private static void PrikazProblema()
        {
            Problem.Margherita margarita = new Problem.Margherita();
            margarita.Priprema();
            margarita.Pecenje();
            margarita.Posluzivanje();
            margarita.Placanje();
            Console.WriteLine($"Uzivam: {margarita}");
            Console.WriteLine();

            Problem.Capricciosa mjesana = new Problem.Capricciosa();
            mjesana.Priprema();
            mjesana.Pecenje();
            mjesana.Posluzivanje();
            mjesana.Placanje();
            Console.WriteLine($"Uzivam: {mjesana}");
            Console.WriteLine();
        }
    }
}
