﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Zadatak02
{
    internal class Program
    {
        private delegate void Broadcast(string message);
        static void Main(string[] args)
        {
            string message = "Sretna Nova godina!";
            PerformMulticast(message);
            PerformMultiActions(message);
        }

        private static void PerformMultiActions(string message)
        {
            Console.WriteLine("MULTICAST Actions");
            Action<string> email = SendEmail;
            Action<string> messageBroadcast = SendMessage;

            Action<string> multicast = email + messageBroadcast;
            //korištenjem lambde dodati neki izraz u multicast
            multicast += (text) => Console.WriteLine($"Slanje texta: {text}");

            //Paziti ako upotrebimo operator "=" onda gubimo sve prijašnje delegate
            //multicast=(text)=>Console.WriteLine($"Slanje texta: {text}");

            multicast -= email;
            multicast -= messageBroadcast;

            //Opsano od pozivanja multicast a nemamo niti jednog delegata
            //multicast(message);
            multicast?.Invoke(message);
        }

        private static void PerformMulticast(string message)
        {
            Console.WriteLine("MULTICAST");
            Broadcast email = SendEmail;
            Broadcast messageBroadcast = SendMessage;

            Broadcast multicast = email + messageBroadcast;
            //korištenjem lambde dodati neki izraz u multicast
            multicast += (text) => Console.WriteLine($"Slanje texta: {text}");

            //Paziti ako upotrebimo operator "=" onda gubimo sve prijašnje delegate
            //multicast=(text)=>Console.WriteLine($"Slanje texta: {text}");

            multicast -= email;
            multicast-=messageBroadcast;
            
            //Opsano od pozivanja multicast a nemamo niti jednog delegata
            //multicast(message);
            multicast?.Invoke(message);

        }

        private static void SendMessage(string message)=>Console.WriteLine($"Message: {message}");

        private static void SendEmail(string message) => Console.WriteLine($"Email: {message}");
    }
}
