﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Zadatak03
{
    internal class Program
    {
        static void Main(string[] args)
        {
            IDictionary<int, string> map = new Dictionary<int, string>();
            IDictionary<string, List<int>> mapWithList
                = new Dictionary<string, List<int>>();

            AddElements(map);
            AddElements(mapWithList);

            PrintElements(map);
            Console.WriteLine();
            PrintElements(mapWithList);
        }

        private static void PrintElements(IDictionary<string, List<int>> map)
        {
            // 1. nacin
            foreach (var item in map)
            {
                string values = string.Join(", ", item.Value);
                Console.WriteLine($"{item.Key}: {values}");
            }

            // 2. nacin
            foreach (string key in map.Keys)
            {
                string values = string.Join(", ", map[key]);
                Console.WriteLine($"{key}: {values}");
            }
        }

        private static void AddElements(IDictionary<string, List<int>> map)
        {
            // ako dinamicki dodajemo elemente, prvo zelimo instancirati
            // listu ako je potrebno
            if (!map.ContainsKey("Pero"))
            {
                map.Add("Pero", new List<int>());
            }

            map["Pero"].Add(3);
            map["Pero"].Add(4);
            map["Pero"].Add(5);
            map["Pero"].Add(4);
        }

        private static void PrintElements(IDictionary<int, string> map)
        {
            // 1. nacin ispisa koristeci KeyValuePair
            //foreach (KeyValuePair<int, string> item in map)
            foreach (var item in map)
            {
                Console.WriteLine($"{item.Key}: {item.Value}");
            }

            // 2. nacin ispisa koristeci Keys
            foreach (int key in map.Keys)
            {
                Console.WriteLine($"{key}: {map[key]}");
            }
        }

        private static void AddElements(IDictionary<int, string> map)
        {
            map.Add(1, "jedan");
            map.Add(2, "dva");
            map[3] = "tri";

            // throwa exception jer key 3 vec postoji
            //map.Add(3, "three");

            // ovo prolazi jer radi update ako key vec postoji
            map[2] = "two";
        }
    }
}
