﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Zadatak02
{
    // IComparable koristimo za predodredji (defaultni) sort
    internal class Book : IComparable<Book>
    {
        // static varijablu koristimo za autoincrement funkcionalnost
        private static int idGenerator = 1;
        // ID se ne moze mijenjati izvana
        public int ID { get; private set; }

        private string isbn;
        public string ISBN
        {
            get => isbn;
            set
            {
                if (!IsValid(value))
                {
                    throw new Exception("ISBN must have 13 digits!");
                }
                isbn = value;
            }
        }

        private bool IsValid(string value)
        {
            if (value.Length != 13)
            {
                return false;
            }

            // return value.All(c => char.IsDigit(c));
            foreach (char c in value)
            {
                if (!char.IsDigit(c))
                {
                    return false;
                }
            }

            return true;
        }

        public string Title { get; set; }
        public string Author { get; set; }

        public Book(string isbn, string title, string author)
        {
            // autoincrement ID-a
            ID = idGenerator++;

            ISBN = isbn;
            Title = title;
            Author = author;
        }

        public override string ToString()
        {
            return $"ID: {ID}, Title: {Title}, Author: {Author}," +
                $"ISBN: {ISBN}";
        }

        public int CompareTo(Book other)
        {
            //long thisIsbn = long.Parse(this.ISBN);
            //long otherIsbn = long.Parse(other.ISBN);

            //if (thisIsbn > otherIsbn)
            //{
            //    // pozitivan je ASC sort
            //    // negativan je DESC sort
            //    return -1;
            //}
            //else if (thisIsbn < otherIsbn)
            //{
            //    return 1;
            //}
            //else
            //{
            //    return 0;
            //}

            //// ASC
            //return this.ISBN.CompareTo(other.ISBN);
            // DESC
            return -this.ISBN.CompareTo(other.ISBN);
        }
    }
}
