﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Zadatak3
{
    internal class Razlomak
    {
        private const char SEPARATOR = '/';
        public int Brojnik {  get; private set; }
        private int nazivnik;
        public int Nazivnik
        {
            get => nazivnik;
            private set
            {
                if (value == 0)
                    throw new Exception("Nazivnik ne smije biti 0!");
                nazivnik = value;
            }
             
        }




        public Razlomak(int brojnik, int nazivnik)
        { 
            int nzd=NajveciZajednickiDjelitelj(brojnik, nazivnik);

            Brojnik = brojnik/nzd;
            Nazivnik=nazivnik/nzd;
        }

        private int NajveciZajednickiDjelitelj(int brojnik, int nazivnik)
        {
            for (int i = Math.Min(brojnik, nazivnik); i >= 2; i--)
            {
                if(brojnik%i == 0 && nazivnik%i==0)
                    return i;
            }
            return 1;
        }


        public static Razlomak Parse(string input)
        {
            string[] detalji = input.Split(SEPARATOR);

            if (detalji.Length != 2)
                return null;
            if(!int.TryParse(detalji[0],out int brojnik) ||
                !int.TryParse(detalji[1], out int nazivnik))
                return null;
            return new Razlomak(brojnik,nazivnik);
        }

        public override string ToString()
        {
            if(Nazivnik==1)
                return Brojnik.ToString();
            return $"{Brojnik}/{Nazivnik}";
        }

        public Razlomak Zbroji(Razlomak drugi)
        {
            int brojnik=this.Brojnik*drugi.Nazivnik + this.Nazivnik*drugi.Brojnik;
            int nazivnik = this.Nazivnik * drugi.Nazivnik;
            return new Razlomak(brojnik,nazivnik);
        }
    }
}
