﻿using PodatkovniSloj;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Klijent
{
    internal class Program
    {
        static void Main(string[] args)
        {
            IRepository repo = RepositoryFactory.GetRepository();

            try
            {
                AddItems(repo);

                ISet<Item> items = repo.GetItems();
                foreach (Item item in items)
                {
                    Console.WriteLine(item);
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
            }
        }

        private static void AddItems(IRepository repo)
        {
            repo.AddItem(new Item
            {
                Id = 1,
                Description = "First Item",
                Date = DateTime.Now,
                User = new User
                {
                    Id = 1,
                    FirstName = "Ana",
                    LastName = "Anic"
                }
            });
            repo.AddItem(new Item
            {
                Id = 2,
                Description = "Second Item",
                // DateTime.Now.AddDays(-1) se odnosi na jucer
                Date = DateTime.Now.AddDays(-1),
                User = new User
                {
                    Id = 2,
                    FirstName = "Pero",
                    LastName = "Peric"
                }
            });
        }
    }
}
