﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Zadatak.Events;
using Zadatak.Models;

namespace Zadatak
{
    internal class Program
    {
        private const string DELIMITER = ",";
        static void Main(string[] args)
        {

            try 
            {
                PersonManager personManager = new PersonManager();
                personManager.OnException += PersonManager_OnException;
                personManager.OnLoaded += PersonManager_OnLoaded;

                SavePersons(personManager);

                IDictionary<string, Person> people = personManager.PeopleDictionary;

                ShowMessage("\nUcitani podaci\n", ConsoleColor.White);
                people.ToList().ForEach(p => ShowMessage($"{p.Value}",  ConsoleColor.Yellow));
            }
            catch(Exception e)
            {
                ShowMessage(e.Message, ConsoleColor.Red);
            }
        }


        //ne trazi se u projektu
        private static void SavePersons(PersonManager personManager)
        {
           IList<Person> people= new List<Person>
            { 
                new Person { Oib="01234567891",Ime="Ana",Prezime="Anic",Email="aanic@net.com",Telefon="01236457"},
                new Person { Oib="0123456789",Ime="Ivo",Prezime="Ivic",Email="iivic@net.com",Telefon="01236457"},
                new Person { Oib="012345678A1",Ime="Franjo",Prezime="Franjic",Email="ffranjic@net.com",Telefon="01236457"},
                new Person { Oib="01234567881",Ime="",Prezime="",Email="",Telefon=""},
                 
            };
            personManager.Save(people);
        }

        private static void PersonManager_OnException(object sender, OnExceptionEventArgs e)
        => ShowMessage(e.Exception.Message, ConsoleColor.Red);

        private static void PersonManager_OnLoaded(object sender, OnLoadedEventArgs e)
        {
            if (e.MissingData.Count == 0)
            {
                ShowMessage(e.LoadedPerson.ToString(), ConsoleColor.Green);
            }
            else
            { 
                string report=string.Join(DELIMITER, e.MissingData);
                ShowMessage(report, ConsoleColor.Blue);
            }
        }

        private static void ShowMessage(string message, ConsoleColor color)
        {
           Console.ForegroundColor = color;
            Console.WriteLine(message);
            Console.ResetColor();
        }
    }
}
