﻿using System;

namespace PodatkovniSloj
{
    public class Item
    {
        public int Id { get; set; }
        public string Description { get; set; }
        public DateTime Date { get; set; }
        public User User { get; set; }

        private const string DATE_FORMAT = "dd.MM.yyyy.";
        private const char SEPARATOR = '|';

        public override string ToString()
        {
            return $"[{Id}]: {Description}, " +
                $"{Date.ToString(DATE_FORMAT)}, ({User})";
        }

        public string FormatForFile()
        {
            return $"{Id}{SEPARATOR}{Description}{SEPARATOR}" +
                $"{Date.ToString(DATE_FORMAT)}{SEPARATOR}" +
                $"{User.FormatForFile()}";
        }

        public static Item ParseFromFile(string line)
        {
            string[] properties = line.Split(SEPARATOR);

            return new Item
            {
                Id = int.Parse(properties[0]),
                Description = properties[1],
                Date = DateTime.ParseExact(properties[2], DATE_FORMAT, null),
                User = User.ParseFromFile(properties[3])
            };
        }
    }
}