﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Zadatak03
{
    internal class Razlomak
    {
        public int Brojnik { get; set; }

        private int nazivnik;
        public int Nazivnik
        {
            get
            {
                return nazivnik;
            }
            set
            {
                if (value == 0)
                {
                    throw new Exception("Nazivnik ne smije biti 0!");
                }
                nazivnik = value;
            }
        }

        public Razlomak() { }
        public Razlomak(int brojnik, int nazivnik)
        {
            Brojnik = brojnik;
            Nazivnik = nazivnik;
        }

        public override string ToString()
        {
            return $"{Brojnik}/{Nazivnik}";
        }

        public Razlomak Pomnozi(Razlomak drugi)
        {
            int noviBrojnik = this.Brojnik * drugi.Brojnik;
            int noviNazivnik = this.Nazivnik * drugi.Nazivnik;

            return new Razlomak(noviBrojnik, noviNazivnik);
        }

        // input npr. "2/3" - zelimo dobiti new Razlomak(2, 3)
        // static metode pozivamo na klasi, a ne instanci klase
        public static Razlomak Parse(string input)
        {
            // 2, 3
            string[] detalji = input.Split('/');

            int brojnik = int.Parse(detalji[0]);
            int nazivnik = int.Parse(detalji[1]);

            //return new Razlomak(brojnik, nazivnik);

            // object initializer
            // ako koristite konstruktor bez parametara, onda mozete izostaviti "obicnu" zagradu
            return new Razlomak/*()*/
            {
                Brojnik = brojnik,
                Nazivnik = nazivnik
            };
        }
    }
}
