﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace TrelloRepo.Model
{
    public class Item
    {
        private const char Del = '#';

        private const string DATE_FORMAT = "dd:MM:yyyy";
       
        public int Id { get; set; }
        public string Description { get; set; }
        public DateTime Date { get; set; }
        public User User { get; set; }
        public override string ToString() => $"{Description}, {Date.ToString(DATE_FORMAT)}, {User}";
        public override bool Equals(object obj) => obj is Item other && Id == other.Id;
        public override int GetHashCode() => Id.GetHashCode();

        public string Format() => $"{Id}{Del}{Description}{Del}{Date.ToString(DATE_FORMAT)}{Del}{User.Format()}";

        public static Item Parse(string line)
        {
            string[] details = line.Split(Del);
            return new Item
            {
                Id = int.Parse(details[0]),
                Description = details[1],
                Date = DateTime.ParseExact(details[2], DATE_FORMAT, null),
                User = User.Parse(details[3])
            };
        }


    }
}
