﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using TrelloRepo.Model;

namespace TrelloRepo.Repository
{
    internal class FileRepository : IRepository
    {
        private const string ItemsPath = @"C:\Users\lecturer\Desktop\data\items.txt";
        private const string UsersPath = @"C:\Users\lecturer\Desktop\data\users.txt";

        public FileRepository()
        {
            if(!File.Exists(ItemsPath))
            {
                File.Create(ItemsPath).Close();
            }
            if(!File.Exists(UsersPath))
            {
                File.Create(UsersPath).Close();
            }
        }

        public void AddItem(Item item)
        {
            AddUser(item.User);
            // TODO add ITEM
            // procitaj sve items
            ISet<Item> set = GetItems();
            // dodaj item
            set.Add(item);
            // zapisi sve iteme
            File.WriteAllLines(ItemsPath, set.Select(i => i.Format()));
        }

        private void AddUser(User user)
        {
            // procitaj sve usere
            ISet<User> set = GetUsers();
            // dodaj usera
            set.Add(user);
            // zapisi sve usere
            File.WriteAllLines(UsersPath, set.Select(u => u.Format()));

        }

        public ISet<Item> GetItems()
        {
            // napravi set
            ISet<Item> set = new HashSet<Item>();
            // napuni set
            // 1. procitaj lajne
            string[] lines = File.ReadAllLines(ItemsPath);
            // 2. svaku lajnu parsaj u usera
            // 3. dodaj usera u set
            lines.ToList().ForEach(line => set.Add(Item.Parse(line)));
            // vrati set
            return set;
        }

        public User GetUser(int id) => GetUsers().FirstOrDefault(u => u.Id == id);
        
        public ISet<User> GetUsers()
        {
            // napravi set
            ISet<User> set = new HashSet<User>();
            // napuni set
            // 1. procitaj lajne
            string[] lines = File.ReadAllLines(UsersPath);
            // 2. svaku lajnu parsaj u usera
            // 3. dodaj usera u set
            lines.ToList().ForEach(line => set.Add(User.Parse(line)));
            // vrati set
            return set;
        }
    }
}
