﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Zadatak02
{
    internal class Program
    {
        private const string PATH = "demo.txt";

        static void Main(string[] args)
        {
            WriteFile(PATH, "prva linija\ndruga linija");
            string message = ReadFile(PATH);
            Console.WriteLine(message);
        }

        private static void WriteFile(string path, string message)
        {
            StreamWriter writer = null;
            try
            {
                writer = File.CreateText(path);
                writer.WriteLine(message);
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
            }
            finally
            {
                //if (writer != null)
                //{
                //    writer.Close();
                //}
                writer?.Close();
            }
        }

        private static string ReadFile(string path)
        {
            try
            {
                // Ako instancirate klasu koja implementira IDisposable
                // interface, onda ju mozete instancirati u USING bloku

                // Using osigurava Disposeanje StreamReadera
                using (StreamReader reader = File.OpenText(path))
                {
                    return reader.ReadToEnd();
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
                return null;
            }
        }
    }
}
