﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace TrelloRepo.Model
{
    public class Item
    {
        private const char DELIMITER = '|';
        private const string DATE_FORMAT = "dd.MM.yyyy";

        public int Id { get; set; }
        public string Opis { get; set; }
        public DateTime Datum { get; set; }
        public User User { get; set; }

        public override string ToString()=>$"{Opis}, {Datum.ToString(DATE_FORMAT)}, {User}";
        public override bool Equals(object obj)=>obj is Item other?Id==other.Id:false ;
        public override int GetHashCode()=>Id.GetHashCode() ;


        internal string FormatForFileLine() => $"{Id}{DELIMITER}{Opis}{DELIMITER}{Datum.ToString(DATE_FORMAT)}{DELIMITER}{User.FormatForFileLine()}";

        internal static Item ParseFromFileLine(string line)
        {
            string[] details= line.Split(DELIMITER) ;
            return new Item
            { 
                Id = int.Parse(details[0]),
                Opis = details[1],
                Datum = DateTime.ParseExact(details[2],DATE_FORMAT,null),
                User=User.ParseFromFileLine(details[3])
            };
        }
    }
}
