﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Zadatak02
{
    internal class Program
    {
        private const string PATH = @"D:\Silvije\OOP\text.txt";
        static void Main(string[] args)
        {
            //ReadFileTest(PATH);
            try
            {
                WriteFile(PATH, "tralala i tako dalje");
                ReadFile(PATH);
            }
            catch(Exception e) { Console.WriteLine(e.Message); }
        }

        private static void ReadFile(string path)
        {
            using (StreamReader reader = File.OpenText(path))
            {
                Console.WriteLine(reader.ReadToEnd());
            }
        }

        private static void WriteFile(string path, string text)
        {
            using (StreamWriter writer = File.CreateText(path))
            { 
                writer.WriteLine(text);
            }
            //ukoliko ne koristimo using, datoteka nece biti disposed
            //na kraju blocka using, kod automatski poziva Dispose() !!!
        }

        private static void ReadFileTest(string path)
        {
            //1. - file  nije stvoren dolazi do pucanja programa, jer exception nije ugrađen - NIJE DOBRO!!
            //StreamReader reader=File.OpenText(path);
            // Console.WriteLine(reader.ReadToEnd());
            // reader.Dispose();//close

            //2. catch sa višestrukim  exceptionom
            StreamReader reader = null;
            try 
            {
                reader = File.OpenText(path);
                Console.WriteLine(reader.ReadToEnd());
            }
            catch(DirectoryNotFoundException e) {Console.WriteLine(e.Message); }
            catch(FileNotFoundException e) {  Console.WriteLine(e.Message); }
            catch(Exception e) { Console.WriteLine(e.Message) ; }
            finally 
            {
                //reader.Dispose(); 

                //if(reader != null)
                //    reader.Dispose();

                //ILI OVAKO
                reader?.Dispose(); //NULL CONDITIONAL OPERATOR
            }
        }
    }
}
