﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Zadatak03
{
    internal class Program
    {
        static void Main(string[] args)
        {
            //AvoidExceptions();
            ImitateTryParse();
        }

        private static void ImitateTryParse()
        {
            int outValue;
            do 
            {
                Console.WriteLine("Number: ");
            }while (!TryParse(Console.ReadLine(), out outValue));
            Console.WriteLine(outValue);

            //ref parametar inicijaliziram prije slanja u metodu
            int refValue = 0;
            do
            {
                Console.WriteLine("Number: ");
            } while (!TryParseRef(Console.ReadLine(), ref refValue));
            Console.WriteLine(refValue);
        }

        private static bool TryParseRef(string text, ref int value)
        {
            try
            {
                value = int.Parse(text);
                return true;
            }
            //možemo ignorirati exception -> ne moramo staviti vrijednost u ref
            catch { } 
            return false;
        }

        private static bool TryParse(string text, out int value)
        {
            try
            {
                value = int.Parse(text);
                return true;
            }
            catch (Exception e) when (//exception filter
                e is ArgumentException ||
                e is FormatException ||
                e is OverflowException)
            { 
                //vanjski parametar mora biti postavljen u metodi
                value= 0;
            }
            return false;
        }

        private static void AvoidExceptions()
        {
            //PROBLEM
            string test = null;//NullReferenceException
            test = "";//IndexOutOfRangeException
            //Console.WriteLine(test.ToLower()[0]);

            //RIJEŠENJA
            //1. manulano
            //if (test != null && test.Length>0)
            //{
            //    Console.WriteLine(test.ToLower()[0]);
            //}

            //2. ternary - definirate "default"
            //test=test!=null && test.Length>0?test:"default";
            //test=!string.IsNullOrEmpty(test)?test:"default";
            //Console.WriteLine(test.ToLower()[0]);

            //3. null coalescing oprator
            //ukoliko operand nije jednak null, daj mi ga, inače vrati default vrijednost
            //takav način sadrži NullReferenceException
            //to vam je varijanta ELVIS opratora
            test = test ?? "milica";
            Console.WriteLine(test.ToLower());

            //4. C# ovo se zove ELVIS (null coalescing oprator)
            //samo handla NullReferenceExcertion
            Console.WriteLine(test?.ToLower());
            //Console.WriteLine(test?[0]);
        }
    }
}
