﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using TrelloRepo.Model;
using TrelloRepo.Repository;

namespace ConsoleClient
{
    internal class Program
    {
        private static readonly IRepository repository = RepositoryFactory.GetRepository();
        static void Main(string[] args)
        {
            FillItems();
            ReadItems();
            Console.WriteLine();
            ReadUsers();
            Console.WriteLine();
            ReadSingleUser();
        }

        private static void FillItems()
        {
            repository.AddItem(
                new Item
                {
                    Date = DateTime.Now.AddDays(-2),
                    Description = "First to do item",
                    Id = 1,
                    User = new User
                    {
                        Id = 1,
                        FirstName = "Militza",
                        LastName = "Krmpotich"
                    }
                }
            );
            repository.AddItem(
                new Item
                {
                    Date = DateTime.Now,
                    Description = "Second to do item",
                    Id = 2,
                    User = new User
                    {
                        Id = 2,
                        FirstName = "Milivoj",
                        LastName = "Lulek"
                    }
                }
            );
            repository.AddItem(
                new Item
                {
                    Date = DateTime.Now.AddDays(1),
                    Description = "Third to do item",
                    Id = 3,
                    User = new User
                    {
                        Id = 2,
                        FirstName = "Milivoj",
                        LastName = "Lulek"
                    }
                }
            );
            // here we try to delete all items
            repository.GetItems().Clear();
        }

        private static void ReadItems() => repository.GetItems().ToList().ForEach(Console.WriteLine);

        private static void ReadUsers() => repository.GetUsers().ToList().ForEach(Console.WriteLine);

        private static void ReadSingleUser() => Console.WriteLine(repository.GetUser(1));
    }
}
