﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Zadatak01
{
    internal class ComplexNumber
    {
        public int Re { get; set; }
        public int Im { get; set; }

        public ComplexNumber(int re, int im)
        {
            Re = re;
            Im = im;
        }

        public override string ToString()
        {
            return $"{Re} + {Im}i";
        }

        public override bool Equals(object obj)
        {
            if (!(obj is ComplexNumber))
            {
                return false;
            }

            ComplexNumber other = obj as ComplexNumber;

            return (this.Re == other.Re && this.Im == other.Im);
        }

        public override int GetHashCode()
        {
            return Re + Im;
        }

        public static bool operator ==(ComplexNumber a, ComplexNumber b)
        {
            return a.Equals(b);
        }

        public static bool operator !=(ComplexNumber a, ComplexNumber b)
        {
            return !(a == b);
        }
    }
}
