﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Zadatak03
{
    internal class Razlomak
    {
        public int Brojnik { get; set; }
        public int Nazivnik { get; set; }

        public Razlomak() { }
        public Razlomak(int brojnik, int nazivnik)
        {
            Brojnik = brojnik;
            Nazivnik = nazivnik;
        }

        public override string ToString()
        {
            return $"{Brojnik}/{Nazivnik}";
        }

        public Razlomak Pomnozi(Razlomak drugi)
        {
            int noviBrojnik = this.Brojnik * drugi.Brojnik;
            int noviNazivnik = this.Nazivnik * drugi.Nazivnik;
            return new Razlomak(noviBrojnik, noviNazivnik);
        }

        // input npr. "2/3" da dobije output new Razlomak(2, 3)
        // static metode se pozivaju na klasi, a ne instanci klase
        public static Razlomak Parse(string input)
        {
            string[] detalji = input.Split('/');

            return new Razlomak
            {
                Brojnik = int.Parse(detalji[0]),
                Nazivnik = int.Parse(detalji[1])
            };
        }
    }
}
