﻿-- Primjer 1.
CREATE PROC dbo.DohvatiSveKupce
AS
SELECT * FROM Kupac
GO

EXEC dbo.DohvatiSveKupce
GO

ALTER PROCEDURE dbo.DohvatiSveKupce
AS
SELECT * FROM Kupac ORDER BY Ime, Prezime
GO

EXEC dbo.DohvatiSveKupce
GO

DROP PROC dbo.DohvatiSveKupce
GO

-- Primjer 2.
CREATE PROC p5
AS
SELECT TOP 10 * FROM Proizvod
SELECT TOP 5 * FROM KreditnaKartica
SELECT TOP 3 * FROM Racun ORDER BY IDRacun DESC
GO

EXEC p5
GO

DROP PROC p5
GO

-- Primjer 3.
CREATE PROC p6
	@AjDiProizvoda int
AS
SELECT * FROM Proizvod WHERE IDProizvod = @AjDiProizvoda
GO

EXEC p6 1
EXEC p6 @AjDiProizvoda = 1
GO

DROP PROC p6
GO

-- Primjer 4.
CREATE PROC p7
	@Cijena1 money,
	@Cijena2 money
AS
SELECT Naziv, CijenaBezPDV FROM Proizvod WHERE CijenaBezPDV BETWEEN @Cijena1 AND @Cijena2
GO

EXEC p7 500, 1000
EXEC p7 @Cijena1 = 500, @Cijena2 = 1000
EXEC p7 @Cijena2 = 1000, @Cijena1 = 500 -- Parametri nisu po redu.
GO

DROP PROC p7
GO

-- Primjer 5.
CREATE PROC p8
	@Tip nvarchar(50),
	@Broj nvarchar(25),
	@IstekMjesec tinyint,
	@IstekGodina smallint
AS
-- Dohvaćanje prije.
SELECT COUNT(*) AS BrojPrije FROM dbo.KreditnaKartica 

-- Umetanje.
INSERT INTO dbo.KreditnaKartica (Tip, Broj, IstekMjesec, IstekGodina)
VALUES (@Tip, @Broj, @IstekMjesec, @IstekGodina)

-- Dohvaćanje nakon.
SELECT COUNT(*) AS BrojNakon FROM dbo.KreditnaKartica 
GO

EXEC p8 'American Express', '12345678901234', 11, 2013
EXEC p8 @Tip = 'Visa', @Broj = '99999999990000', @IstekMjesec = 5, @IstekGodina = 2014
GO

DROP PROC p8
GO

-- Primjer 6.
CREATE PROC p9
	@Boja1 nvarchar(15),
	@Boja2 nvarchar(15),
	@Boja3 nvarchar(15)
AS
SELECT * FROM Proizvod WHERE Boja = @Boja1
SELECT * FROM Proizvod WHERE Boja = @Boja2
SELECT * FROM Proizvod WHERE Boja = @Boja3
GO

EXEC p9 'Red', 'Žuta', 'Black'
GO

DROP PROC p9
GO

-- Primjer 7.
CREATE PROC p10
	@IDProizvod int,
	@Boja nvarchar(15) OUTPUT
AS
SELECT @Boja = Boja FROM Proizvod WHERE IDProizvod = @IDProizvod
GO

DECLARE @Farba nvarchar(15)
EXEC p10 320, @Farba OUTPUT
PRINT @Farba
GO

DECLARE @Farba nvarchar(15)
EXEC p10 @IDProizvod = 320, @Boja = @Farba OUTPUT
PRINT @Farba
GO

DROP PROC p10
GO

-- Primjer 8.
CREATE PROC p11
	@Filter nvarchar(50),
	@BrojZapisa int OUTPUT
AS
SELECT @BrojZapisa = COUNT(*) FROM Kupac WHERE Prezime LIKE @Filter

SELECT * FROM Kupac WHERE Prezime LIKE @Filter
GO

DECLARE @Cnt int
EXEC p11 '%abe%', @Cnt OUTPUT
PRINT @Cnt
GO

DROP PROC p11
GO

-- Primjer 9.
CREATE PROC p12
	@KomercijalistID int,
	@Ime nvarchar(50) OUTPUT,
	@Prezime nvarchar(50) OUTPUT,
	@IzdaoRacuna int OUTPUT
AS
SELECT 
	@Ime = k.Ime, 
	@Prezime = k.Prezime, 
	@IzdaoRacuna = COUNT(*)
FROM Komercijalist AS k
INNER JOIN Racun AS r ON k.IDKomercijalist = r.KomercijalistID
WHERE k.IDKomercijalist = @KomercijalistID
GROUP BY k.Ime, k.Prezime
GO

DECLARE @Ime nvarchar(50), @Prezime nvarchar(50), @IzdaoRacuna int
EXEC p12 276, @Ime OUTPUT, @Prezime OUTPUT, @IzdaoRacuna OUTPUT
SELECT @Ime
SELECT @Prezime
SELECT @IzdaoRacuna
GO

DROP PROC p12
GO

-- Primjer 10.
CREATE PROC p13
	@Ime nvarchar(50),
	@Prezime nvarchar(50)
AS
IF EXISTS(SELECT * FROM Kupac WHERE Ime = @Ime AND Prezime = @Prezime)
	RETURN 0
ELSE
	RETURN 200
GO

DECLARE @RetVal int
EXEC @RetVal = p13 'Amy', 'Alberts'
PRINT @RetVal
GO

DECLARE @RetVal int
EXEC @RetVal = p13 'Paško', 'Patak'
PRINT @RetVal
GO

-- Primjer 11.
ALTER PROC p13
	@Ime nvarchar(50),
	@Prezime nvarchar(50)
WITH ENCRYPTION
AS
IF EXISTS(SELECT * FROM Kupac WHERE Ime = @Ime AND Prezime = @Prezime)
	RETURN 0
ELSE
	RETURN 200
GO

-- Primjer 12.
DROP PROC p13
GO

-- Primjer 13.
CREATE TABLE Student
(
	IDStudent int CONSTRAINT PK_Student PRIMARY KEY IDENTITY,
	Ime nvarchar(50),
	Prezime nvarchar(50),
	JMBAG char(11)
)
GO

INSERT INTO Student (Ime, Prezime, JMBAG) VALUES ('Miro', 'Mirić', '111222333')
INSERT INTO Student (Ime, Prezime, JMBAG) VALUES ('Ana', 'Anić', '999888777')
GO

CREATE PROC p16
AS
SELECT Ime, Prezime FROM Student
GO

EXEC p16
GO

-- Primjer 14.
ALTER PROC p16
AS
SELECT Ime, Prezime, DatumRodjenja FROM Student
GO

-- Primjer 15.
ALTER PROC p16
AS
SELECT * FROM IzmisljenaTablica
GO

EXEC p16
GO

-- Primjer 16.
CREATE TABLE IzmisljenaTablica
(
	Naziv nvarchar(50)
)
GO

EXEC p16
GO
