/*
ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW
ROWS BETWEEN CURRENT ROW AND 3 FOLLOWING
ROWS BETWEEN 1 PRECEDING AND 1 FOLLOWING
ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING

RANGE BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW
RANGE BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING
*/

select
	*,
	last_VALUE(Naziv) over (partition by Boja order by Naziv rows between unbounded preceding and unbounded following) as a1
from Proizvod
where Boja is not null
order by Boja, Naziv

select
	*,
	LAST_VALUE(Naziv) over (partition by Boja order by Naziv rows between current row and unbounded following) as a1
from Proizvod
where Boja is not null
order by Boja, Naziv

select s.RacunID, s.Kolicina, 
    sum(s.Kolicina) over (order by s.racunid rows between 1 preceding and 2 following) as A
	, sum(s.Kolicina) over (order by s.racunid rows between unbounded preceding and 3 following) as B
	, sum(s.Kolicina) over (order by s.racunid rows between current row and 3 following) as C
	, sum(s.Kolicina) over (order by s.racunid range between unbounded preceding and current row) as D
	, sum(s.Kolicina) over (order by s.racunid rows between unbounded preceding and current row) as E
from stavka as s
where s.Kolicina>1


