/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package hr.algebra.list;

import hr.algebra.model.Product;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;


/**
 *
 * @author dnlbe
 */
public class Main {
    
    public static void main(String[] args) {        
       
        // diamond operator '<>'
        //List<Product> list = new ArrayList<>();       
        
        List<Product> products = new LinkedList<>();

        products.add(new Product(3, "Ball", 3.99));
        products.add(new Product(1, "Table", 12.99));
        products.add(new Product(2, "Cellular", 69.99));
        
        System.out.println(products.get(2)); // expensive in LinkedList, good for ArrayList
        
        System.out.println("Iterator:");
        // how enhanced for looop actually works:
//        for (Product product : list) {
//            System.out.println(product);
//        }
        Iterator<Product> iterator = products.iterator();
        while (iterator.hasNext()) {
            System.out.println(iterator.next());
        }        
        
        System.out.println("All products:");
        products.forEach(System.out::println);
        
        System.out.println("After removal, update and add:");
        Product duplicate = new Product(3, "Ball", 3.99);
        // remove does not work without equals!
        products.remove(duplicate); // this is expensive in ArrayList, but not in LinkedList - it uses equals()
        products.remove(0); // this is expensive in ArrayList, but not in LinkedList
        products.set(0, new Product(4, "Skate", 15.99));
        products.add(0, new Product(5, "Racket", 11.99)); // this is expensive in ArrayList, but not in LinkedList
        products.add(1, new Product(6, "Rollerblades", 20.99)); // this is expensive in ArrayList, but not in LinkedList
        
        products.removeIf(p -> p.getPrice() < 15);
        
        products.forEach(System.out::println); 
        
        Collections.sort(products, (p1, p2) -> Double.compare(p1.getPrice(), p2.getPrice()));
        System.out.println("Sorted by price asc:");
        products.forEach(System.out::println);
        
        Collections.reverse(products);
        System.out.println("Sorted by price desc:");
        products.forEach(System.out::println);
        
        if (products instanceof LinkedList) {
            System.out.println("popped out: " + ((LinkedList<Product>)products).pop());
        }
        System.out.println("After popping:");
        products.forEach(System.out::println);
        
        products.clear();
        System.out.println("After clear:");
        System.out.println(products); // toString()
        
        
    }
}
