/*
 * Click nbfs://nbhost/SystemFileSystem/Templates/Licenses/license-default.txt to change this license
 */
package hr.algebra;

import hr.algebra.model.Car;
import hr.algebra.model.Skateboard;
import hr.algebra.model.SportCar;
import hr.algebra.model.Switchable;
import hr.algebra.model.Vehicle;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 *
 * @author daniel.bele
 */
public class Lecture02 {

    public static void main(String[] args) {

        /*      
        // abstraction cannot be initialized(but we can provide inline implementation):
        //Vehicle vehicle = new Vehicle();
        
        Vehicle car = new Car("Mercedes", 8.4);        
        Vehicle sportCar = new SportCar("Ferrari", 3.6, true);
        Vehicle skate = new Skateboard("Santa Monica");
        
        List<Vehicle> vehicles = new ArrayList<>();
        vehicles.add(sportCar);
        vehicles.add(car);
        vehicles.add(skate);
         */
        // it can be done this way, but it is not the same
        // this creates immutable list - makes sense - it wraps an array!
        List<Vehicle> vehicles = Arrays.asList( // varargs, explain the abstractions, finish with List.of 
                new Car("Mercedes", 8.4),
                new SportCar("Ferrari", 3.6, true),
                new Skateboard("Santa Monica"),
                // inline implementation of abstract class, got an id 
                new Vehicle() {
                    @Override
                    public void drive() {
                        System.out.println("Anonymous vehicle driving");
                    }

                    @Override
                    public void stop() {
                        System.out.println("Anonymous vehicle stopping");
                    }
                    // if we do not implement toString(), the default implementation clearly shows how Anonymous classes
                    // exist on the filesystem -> it is compiled in concrete class Lecture02$1.class
                    // now we can understand why java.base module, java.io package has Console$1.class

                    @Override
                    public String toString() {
                        return "Anonymous vehicle";
                    }
            }
        );

        // immutable means we cannot add or remove, but we can change contents (and reorder):
        //vehicles.add(new Skateboard("Black label"));
        //vehicles.remove(0);
        //vehicles.set(0, new Skateboard("Powell Peralta"));
        System.out.println("All vehicles:");
        for (var vehicle : vehicles) {
            System.out.println(vehicle);
            if (vehicle instanceof Switchable switchable) { // pattern matching
                switchable.switchOn();
            }
            vehicle.drive();
            if (vehicle instanceof SportCar sportCar) {
                sportCar.drift();
            }
            vehicle.stop();
            if (vehicle instanceof Switchable switchable) {
                switchable.switchOff();
            }
        }

        Collections.sort(vehicles);
        System.out.println("Sorted vehicles - Comparable:");

        // this also creates class on the filesystem -> Main$2.class
/*        
        vehicles.forEach(new Consumer<Vehicle>() {
            @Override
            public void accept(Vehicle v) {
                System.out.println(v);
            }
        });
         */
        // this does not create class on filesystem - it is created dinamically at runtime
        vehicles.forEach(v -> System.out.println(v));

        /*        
        Collections.sort(vehicles, new Comparator<Vehicle>() {
            @Override
            public int compare(Vehicle o1, Vehicle o2) {
                return -Integer.valueOf(o1.getId()).compareTo(o2.getId());
            }
        });
         */
        // forced boxing vs autoboxing
        Collections.sort(vehicles, (o1, o2) -> -Integer.valueOf(o1.getId()).compareTo(o2.getId()));
        System.out.println("Sorted vehicles - Comparator:");
        // method reference
        vehicles.forEach(System.out::println);
    }
}
