/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package hr.algebra.view;

import hr.algebra.view.model.FileTreeModel;
import hr.algebra.utilities.FileUtils;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

/**
 *
 * @author dnlbe
 */
public class FileSearcher extends javax.swing.JFrame {

    /**
     * Creates new form FileSearcher
     */
    public FileSearcher() {
        initComponents();
        init();
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();
        tfFilename = new javax.swing.JTextField();
        btnSearch = new javax.swing.JButton();
        cbRoots = new javax.swing.JComboBox<>();
        jScrollPane1 = new javax.swing.JScrollPane();
        trFilesystem = new javax.swing.JTree();
        jToolBar1 = new javax.swing.JToolBar();
        lbReport = new javax.swing.JLabel();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("Search for files");
        setMaximumSize(new java.awt.Dimension(600, 454));
        setMinimumSize(new java.awt.Dimension(600, 454));
        setPreferredSize(new java.awt.Dimension(600, 454));
        setResizable(false);

        jPanel1.setPreferredSize(new java.awt.Dimension(461, 66));

        btnSearch.setText("Search");
        btnSearch.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnSearchActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap(24, Short.MAX_VALUE)
                .addComponent(cbRoots, javax.swing.GroupLayout.PREFERRED_SIZE, 82, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addComponent(tfFilename, javax.swing.GroupLayout.PREFERRED_SIZE, 323, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(30, 30, 30)
                .addComponent(btnSearch, javax.swing.GroupLayout.PREFERRED_SIZE, 82, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(41, 41, 41))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup()
                .addGap(32, 32, 32)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(tfFilename, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(btnSearch)
                    .addComponent(cbRoots, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        getContentPane().add(jPanel1, java.awt.BorderLayout.PAGE_START);

        trFilesystem.setModel(null);
        jScrollPane1.setViewportView(trFilesystem);

        getContentPane().add(jScrollPane1, java.awt.BorderLayout.CENTER);

        jToolBar1.setRollover(true);

        lbReport.setFont(new java.awt.Font("Tahoma", 0, 18)); // NOI18N
        lbReport.setForeground(new java.awt.Color(0, 153, 153));
        lbReport.setText("Please choose partition and filename");
        lbReport.setToolTipText("");
        jToolBar1.add(lbReport);

        getContentPane().add(jToolBar1, java.awt.BorderLayout.PAGE_END);

        pack();
        setLocationRelativeTo(null);
    }// </editor-fold>//GEN-END:initComponents

    private void btnSearchActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnSearchActionPerformed

        if (!FileUtils.filenameHasExtension(tfFilename.getText().trim(), 3)) {
            lbReport.setText("Please use filename with an extension");
            return;
        }
        
        handleGui(true);
        // we should perform search in background thread not to freeze the gui        
        new Thread(() -> {
            try {
                findFile((String) cbRoots.getSelectedItem(), tfFilename.getText().trim());
            } catch (IOException ex) {
                Logger.getLogger(FileSearcher.class.getName()).log(Level.SEVERE, null, ex);
            }
        }).start();
    }//GEN-LAST:event_btnSearchActionPerformed

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        /* Set the Nimbus look and feel */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html 
         */
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException | InstantiationException | IllegalAccessException | javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(FileSearcher.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>
        //</editor-fold>
        
        //</editor-fold>
        //</editor-fold>

        /* Create and display the form */
        java.awt.EventQueue.invokeLater(() -> {
            new FileSearcher().setVisible(true);
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnSearch;
    private javax.swing.JComboBox<String> cbRoots;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JToolBar jToolBar1;
    private javax.swing.JLabel lbReport;
    private javax.swing.JTextField tfFilename;
    private javax.swing.JTree trFilesystem;
    // End of variables declaration//GEN-END:variables

    private void init() {
        initRoots();
        initTree();
        tfFilename.requestFocus();
    }
    
    private void initRoots() {
        DefaultComboBoxModel<String> rootsModel = new DefaultComboBoxModel<>();
        Arrays.asList(File.listRoots()).forEach(root -> rootsModel.addElement(root.getPath()));
        cbRoots.setModel(rootsModel);
    }
    
    // the model of JTree must be explicitly set to null!
     private void initTree() {
        trFilesystem.setCellRenderer(new DefaultTreeCellRenderer() {
            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (leaf) {
                    setIcon(leafIcon);
                } else {
                    setIcon(expanded ? openIcon : closedIcon);
                }
                File file = (File)value;
                setText(file.getName().isEmpty() ? file.getPath() : file.getName());
                return this;
            }
        });
    }

    private void findFile(String path, String filename) throws IOException {
        Path rootPath = Paths.get(path);
        Files.walkFileTree(rootPath, new SimpleFileVisitor<Path>() {
            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (file.endsWith(filename)) {
                    //System.out.println(file.toAbsolutePath());
                    setTreeModel(rootPath.toFile(), file.toFile());
                    return FileVisitResult.TERMINATE;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                if (exc instanceof AccessDeniedException) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return super.visitFileFailed(file, exc);
            }
        });
    }

    private void setTreeModel(File root, File targetFile) {

        // search is done -> let us notify the EventThread to render the FileTreeModel
        java.awt.EventQueue.invokeLater(() -> {
            trFilesystem.setModel(new FileTreeModel(root, targetFile));
            for (int i = 0; i < trFilesystem.getRowCount(); i++) {
                trFilesystem.expandRow(i);
            }
            handleGui(false);
        });
    }

    private void handleGui(boolean searching) {        
        lbReport.setText(searching ? "Please wait while the search lasts" : "Please choose partition and filename");
        btnSearch.setEnabled(!searching);
    }

}
