/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package hr.algebra.closeable;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author dnlbe
 */
public class Main {

    private static final String PATH = "src/main/java/hr/algebra/closeable/Main.java";
    
    public static void main(String[] args) {        
        finallyExample();        
        tryWithResourcesExample();        
        dummyExample();
    }    

    private static void finallyExample() {
        Scanner scanner = null;
        try {
            scanner = new Scanner(new File(PATH));
            while (scanner.hasNextLine()) {                
                System.out.println(scanner.nextLine());
            }
        } catch (FileNotFoundException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
        } finally {
            if (scanner != null) {
                scanner.close();
            }
        }
    }

    private static void tryWithResourcesExample() {
        try (Scanner scanner = new Scanner(new File(PATH))){
            while (scanner.hasNextLine()) {                
                System.out.println(scanner.nextLine());
            }
        } catch (FileNotFoundException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private static void dummyExample() {
        
        try (Dummy dummy = new Dummy()){
            //return;
            //System.exit(1);
        } catch (IOException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
        } 
    }
    
    private static class Dummy implements Closeable{
        @Override
        public void close() throws IOException {
            System.out.println("Miroslav");
        }
    }
}
