/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package hr.algebra.map;

import hr.algebra.model.Product;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;

/**
 *
 * @author dnlbe
 */
public class Main {

    public static void main(String[] args) {

        //Map<String, Product> productsMap = new HashMap<>();
        //Map<String, Product> productsMap = new TreeMap<>();
        Map<String, Product> productsMap = new TreeMap<>((k1, k2) -> Integer.compare(k1.length(), k2.length()));

        // put replaces the value if key is already present -> dangerous! (in C# it throws an Exception!)
        if (!productsMap.containsKey("Table")) {
            productsMap.put("Table", new Product(1, "Table", 12.99));
        }
        // this one is even better:
        Arrays.asList(
                new Product(3, "Ball", 3.99),
                new Product(1, "Table", 12.99),
                new Product(2, "Cellular", 69.99),
                new Product(4, "Skate", 15.99),
                new Product(5, "Racket", 11.99),
                new Product(6, "Rollerblades", 20.99)
        ).forEach(p -> productsMap.putIfAbsent(p.getTitle(), p));

        System.out.println("Keys:");
        productsMap.keySet().forEach(System.out::println);

        System.out.println("Values:");
        productsMap.values().forEach(System.out::println);

        System.out.println("All products:");
        productsMap.forEach((k, v) -> System.out.printf("%s: %s%n", k, v));
        
        System.out.println("Entries:");
        productsMap.entrySet().forEach(System.out::println);
        
        System.out.println("toString():");
        System.out.println(productsMap);

    }
}
