/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package hr.algebra.model;

/**
 *
 * @author dnlbe
 */
public final class Product implements Comparable<Product>{
    
    private final int id;
    private final String title;
    private final double price;

    public Product(int id, String title, double price) {
        this.id = id;
        this.title = title;
        this.price = price;
    }

    public double getPrice() {
        return price;
    }

    public String getTitle() {
        return title;
    }    

    @Override
    public String toString() {
        return "Product{" + "id=" + id + ", title=" + title + ", price=" + price + '}';
    }
    
    @Override
    public boolean equals(Object obj) {
        return obj instanceof Product product ? id == product.id : false;
    }

    @Override
    public int hashCode() {
        return Integer.valueOf(id).hashCode();
    }

    @Override
    public int compareTo(Product o) {
        return title.compareTo(o.title);
    }
    
}
