/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package hr.algebra.functional.builtin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.function.BinaryOperator;
import java.util.function.DoubleFunction;
import java.util.function.DoubleToLongFunction;
import java.util.function.IntBinaryOperator;
import java.util.function.IntUnaryOperator;
import java.util.function.Supplier;
import java.util.function.ToLongFunction;
import java.util.function.UnaryOperator;


/**
 *
 * @author dnlbe
 */
public class Main {

    public static void main(String[] args) {

        List<String> names = new ArrayList<>(Arrays.asList("Milica", "Gojko", "Milivoj", "Svemirko"));
        
        handleConsumer(names);
        handlePredicate(names);
        handleFunction(names);
        handleSupplier(names);
        handlePrimitive();
        handleBinaryAndUnary();
    }

    private static void handleConsumer(List<String> names) {
//        Consumer<String> consumer = new Consumer<String>() {
//            @Override
//            public void accept(String s) {
//                System.out.println(s);
//            }
//        };
//        Consumer<String> consumer = s -> System.out.println(s);
//        Consumer<String> consumer = System.out::println;
//        consumer.accept("Robert MeDiro");
        System.out.println("All names:");
//        names.forEach(consumer);
        names.forEach(System.out::println);
    }

    private static void handlePredicate(List<String> names) {
//        Predicate<String> predicate = new Predicate<String>() {
//            @Override
//            public boolean test(String s) {
//                return s.startsWith("M") && s.length() > 6;
//            }
//        };
//        Predicate<String> predicate = s -> s.startsWith("M") && s.length() > 6;
//        System.out.println(predicate.test("Milutin"));
//        names.removeIf(predicate);
        names.removeIf(s -> s.startsWith("M") && s.length() > 6);

        System.out.println("Filtered names:");
        names.forEach(System.out::println);
    }

    private static void handleFunction(List<String> names) {
//        Function<String, Integer> function = new Function<String, Integer>() {
//            @Override
//            public Integer apply(String s) {
//                return s.length();
//            }
//        };

        //Function<String, Integer> function = s -> s.length();
//        Function<String, Integer> function = String::length;
//        System.out.println(function.apply("Robert MeDiro"));
        System.out.println("Name lengths:");
        //names.stream().map(function).forEach(System.out::println);
        names.stream().map(String::length).forEach(System.out::println);
    }

    private static void handleSupplier(List<String> names) {
//        Supplier<String> supplier = new Supplier<String>() {
//            @Override
//            public String get() {
//                return  UUID.randomUUID().toString().substring(0, 9);;
//            }
//        };
        Supplier<String> supplier = () -> UUID.randomUUID().toString().substring(0, 9);
        names.add(supplier.get());
        System.out.println("List with supplied value:");
        names.forEach(System.out::println);

        // this is not so smart
        supplier = String::new;
        names.add(1, supplier.get());
        System.out.println("List with supplied empty value:");
        names.forEach(System.out::println); 
    }

    // avoiding auto-boxing and unboxing
    private static void handlePrimitive() {
        //DoubleFunction<Long> primitiveDoubleToLong = d -> Math.round(d);
        DoubleFunction<Long> primitiveDoubleToLong = Math::round;
        System.out.println("PI rounded: " + primitiveDoubleToLong.apply(Math.PI));

        ToLongFunction<Double> doubleToPrimitiveLong = Math::round;
        System.out.println("PI rounded: " + doubleToPrimitiveLong.applyAsLong(Math.PI));

        DoubleToLongFunction primitiveDoubleToPrimitiveLong = Math::round;
        System.out.println("PI rounded: " + primitiveDoubleToPrimitiveLong.applyAsLong(Math.PI));
    }

    // same parameters and return values
    private static void handleBinaryAndUnary() {
        //BiFunction<Integer, Integer, Integer> add = (a, b) -> a + b;
        // takes 2 and returns 1 parameter, all of same type
        BinaryOperator<Integer> add = (a, b) -> a + b;
        System.out.printf("1 + 2 = %d%n", add.apply(1, 2));

        // takes 2 and returns 1 primitive parameter, all of type int
        IntBinaryOperator addBinary = (a, b) -> a + b;
        System.out.printf("1 + 2 = %d%n", addBinary.applyAsInt(1, 2));

        //Function<Integer, Integer> modulo = x -> x % 2;
        // takes 1 and returns 1 parameter parameter, all of same type
        UnaryOperator<Integer> modulo = x -> x % 2;
        System.out.printf("5 %% 2 = %d%n", modulo.apply(5));

        // takes 1 and returns 1 primitive parameter, all of type int
        IntUnaryOperator moduloUnary = x -> x % 2;
        System.out.printf("5 %% 2 = %d%n", moduloUnary.applyAsInt(5));     
    }
}
