/*
 * Click nbfs://nbhost/SystemFileSystem/Templates/Licenses/license-default.txt to change this license
 */
package hr.algebra.functional.custom;

import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.DoubleBinaryOperator;

/**
 *
 * @author daniel.bele
 */
public class Main {

    public static void main(String[] args) {
        double x = 1.2;
        double y = 2.4;

        Operation operation = new AddOperation();
        operation.applyWithPrint(x, y, "+", System.out);
        operation = (a, b) -> Math.pow(a, b);
        operation = Math::pow;
        operation.applyWithPrint(x, y, "pow", System.out);
        operation = new Operation() {
            @Override
            public double apply(double a, double b) {
                return a - b;
            }
        };
        operation = (a, b) -> a * b;
        handleOperation(x, y, operation);
        handleOperation(x, y, (a, b) -> a - b);
        handleOperation(x, y, (a, b) -> {
            if (b == 0) return 0;
            return a / b;
        });
        handleOperation(x, y, (a, b) -> b == 0 ? 0 : a / b);
        
        List<Operation> operations = Arrays.asList(
                Math::pow,
                Math::atan2,
                (a, b) -> Math.sqrt(Math.pow(a, 2) + Math.pow(b, 2))
        );
        System.out.println();
        for (Operation op : operations) {
            handleOperation(x, y, op);
        }
        operations.forEach(new Consumer<Operation>() {
            @Override
            public void accept(Operation op) {
                handleOperation(x, y, op);
            }
        });
        operations.forEach(op -> handleOperation(x, y, op));
        System.out.println();
        DoubleBinaryOperator binaryOperator = (a, b) -> a + b;
        handleDoubleBinaryOperator(x, y, binaryOperator);
        handleDoubleBinaryOperator(x, y, Math::pow);
        
    }

    private static void handleOperation(double x, double y, Operation operation) {
        System.out.printf("Result: %.2f%n", operation.apply(x, y));
    }

    private static void handleDoubleBinaryOperator(double x, double y, DoubleBinaryOperator binaryOperator) {
        System.out.printf("Result: %.2f%n", binaryOperator.applyAsDouble(x, y));
    }
}
