/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package hr.algebra.model;

import java.time.LocalDate;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

/**
 *
 * @author dnlbe
 */
@XmlAccessorType(XmlAccessType.FIELD)
public class Movie {

    // ako ne zelimo da se serijalizira:
    //@XmlTransient 
    @XmlAttribute
    private int id;
    private String title;
    private Genre genre;
    private int duration;
    private Person director;
    @XmlElementWrapper
    @XmlElement(name = "actor")
    private List<Person> actors;
    @XmlJavaTypeAdapter(PublishedDateAdapter.class)
    @XmlElement(name = "publisheddate")
    private LocalDate publishedDate;
    private Person reviewer;

    public Movie() {
    }

    public Movie(int id, String title, Genre genre, int duration, Person director, List<Person> actors, LocalDate publishedDate, Person reviewer) {
        this.id = id;
        this.title = title;
        this.genre = genre;
        this.duration = duration;
        this.director = director;
        this.actors = actors;
        this.publishedDate = publishedDate;
        this.reviewer = reviewer;
    }

    @Override
    public String toString() {
        return "Movie{" + "id=" + id + ", title=" + title + ", genre=" + genre + ", duration=" + duration + ", director=" + director + ", actors=" + actors + ", publishedDate=" + publishedDate + ", reviewer=" + reviewer + '}';
    }

}
