/*
 * Click nbfs://nbhost/SystemFileSystem/Templates/Licenses/license-default.txt to change this license
 * Click nbfs://nbhost/SystemFileSystem/Templates/GUIForms/JFrame.java to edit this template
 */
package hr.algebra;

import hr.algebra.model.Person;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultListModel;

/**
 *
 * @author lecturer
 */
public class Task02 extends javax.swing.JFrame {

    /**
     * Creates new form Task02
     */
    public Task02() {
        initComponents();

    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        tfFirst = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        tfLast = new javax.swing.JTextField();
        jScrollPane1 = new javax.swing.JScrollPane();
        lsPeople = new javax.swing.JList<>();
        btnFDESC = new javax.swing.JButton();
        btnFASC = new javax.swing.JButton();
        btnLDESC = new javax.swing.JButton();
        btnLASC = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("Sorter");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowOpened(java.awt.event.WindowEvent evt) {
                formWindowOpened(evt);
            }
        });

        jLabel1.setText("First name");

        tfFirst.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                Task02.this.keyReleased(evt);
            }
        });

        jLabel2.setText("Last name");

        tfLast.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                Task02.this.keyReleased(evt);
            }
        });

        jScrollPane1.setViewportView(lsPeople);

        btnFDESC.setText("FDESC");
        btnFDESC.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnFDESCActionPerformed(evt);
            }
        });

        btnFASC.setText("FASC");
        btnFASC.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnFASCActionPerformed(evt);
            }
        });

        btnLDESC.setText("LDESC");
        btnLDESC.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnLDESCActionPerformed(evt);
            }
        });

        btnLASC.setText("LASC");
        btnLASC.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnLASCActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addGroup(javax.swing.GroupLayout.Alignment.LEADING, layout.createSequentialGroup()
                        .addGap(19, 19, 19)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(jLabel2, javax.swing.GroupLayout.PREFERRED_SIZE, 90, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(tfLast, javax.swing.GroupLayout.PREFERRED_SIZE, 96, javax.swing.GroupLayout.PREFERRED_SIZE))
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(jLabel1, javax.swing.GroupLayout.PREFERRED_SIZE, 90, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(tfFirst, javax.swing.GroupLayout.PREFERRED_SIZE, 96, javax.swing.GroupLayout.PREFERRED_SIZE)))
                        .addGap(69, 69, 69)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 258, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(btnFDESC)))
                    .addGroup(layout.createSequentialGroup()
                        .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(btnFASC)
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(btnLASC)
                                .addGap(98, 98, 98)
                                .addComponent(btnLDESC)))))
                .addContainerGap(62, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(32, 32, 32)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLabel1, javax.swing.GroupLayout.PREFERRED_SIZE, 27, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(tfFirst, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLabel2, javax.swing.GroupLayout.PREFERRED_SIZE, 27, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(tfLast, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))))
                .addGap(37, 37, 37)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(btnFDESC)
                    .addComponent(btnFASC))
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(btnLASC)
                    .addComponent(btnLDESC))
                .addContainerGap(37, Short.MAX_VALUE))
        );

        pack();
        setLocationRelativeTo(null);
    }// </editor-fold>//GEN-END:initComponents

    private void keyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_keyReleased
        loadModel();
    }//GEN-LAST:event_keyReleased

    private void btnFASCActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnFASCActionPerformed
        Collections.sort(list, (l, r) -> l.getFirstName().compareToIgnoreCase(r.getFirstName()));
        loadModel();
    }//GEN-LAST:event_btnFASCActionPerformed

    private void btnFDESCActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnFDESCActionPerformed
        Collections.sort(list, (l, r) -> -l.getFirstName().compareToIgnoreCase(r.getFirstName()));
        loadModel();
    }//GEN-LAST:event_btnFDESCActionPerformed

    private void btnLASCActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnLASCActionPerformed
        Collections.sort(list, (l, r) -> l.getLastName().compareToIgnoreCase(r.getLastName()));
        loadModel();
    }//GEN-LAST:event_btnLASCActionPerformed

    private void btnLDESCActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnLDESCActionPerformed
        Collections.sort(list, (l, r) -> -l.getLastName().compareToIgnoreCase(r.getLastName()));
        loadModel();
    }//GEN-LAST:event_btnLDESCActionPerformed

    private void formWindowOpened(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowOpened
        geneneratePeople();
        Collections.sort(list);
        loadModel();
    }//GEN-LAST:event_formWindowOpened

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        /* Set the Nimbus look and feel */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html 
         */
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(Task02.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(Task02.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(Task02.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(Task02.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>

        /* Create and display the form */
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new Task02().setVisible(true);
            }
        });
    }

    private final List<Person> list = new ArrayList<>();
    private final DefaultListModel<Person> model = new DefaultListModel<>();

    private void loadModel() {
        model.clear();
        list
                .stream()
                .filter(p -> {
                    boolean test = true;
                    test &= p
                            .getFirstName()
                            .toLowerCase()
                            .startsWith(tfFirst
                                    .getText()
                                    .trim()
                                    .toLowerCase());
                    test &= p
                            .getLastName()
                            .toLowerCase()
                            .startsWith(tfLast
                                    .getText()
                                    .trim()
                                    .toLowerCase());
                    
                    return test;
                })
                .forEach(model::addElement);
        lsPeople.setModel(model);

    }


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnFASC;
    private javax.swing.JButton btnFDESC;
    private javax.swing.JButton btnLASC;
    private javax.swing.JButton btnLDESC;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JList<Person> lsPeople;
    private javax.swing.JTextField tfFirst;
    private javax.swing.JTextField tfLast;
    // End of variables declaration//GEN-END:variables

    private void geneneratePeople() {
        list.add(new Person("Milivoj", "Lullek", 1));
        list.add(new Person("Gargamel", "Gibson", 2));
        list.add(new Person("Robert", "Me Diro", 4));
        list.add(new Person("Sad dam sad nedam", "Husein", 3));
        list.add(new Person("Ćenifa", "Lopez", 5));
    
    }
}
