/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package hr.algebra;

import hr.algebra.model.Genre;
import hr.algebra.model.Movie;
import hr.algebra.model.MovieStore;
import hr.algebra.model.Person;
import hr.algebra.utils.JAXBUtils;
import java.time.LocalDate;
import java.time.Month;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.bind.JAXBException;

/**
 *
 * @author dnlbe
 */
public class Main {

    private static final String FILENAME = "moviestore.xml";

    public static void main(String[] args) {

        MovieStore store = createFakeStore();
        System.out.println(store);

        try {
            JAXBUtils.save(store, FILENAME);
            //store = (MovieStore) JAXBUtils.load(MovieStore.class, FILENAME);
            store = JAXBUtils.load(MovieStore.class, FILENAME);
            System.out.println(store);
        } catch (JAXBException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static MovieStore createFakeStore() {

        List<Person> actorsHollywood = Stream.of(
                new Person("Brad", "Pitt"),
                new Person("Leonardo", "DiCaprio"),
                new Person("Margot", "Robbie")
        ).collect(Collectors.toList());

        List<Person> actorsJoker = Stream.of(
                new Person("Joaquin", "Phoenix"),
                new Person("Robert", "Me Diro"),
                new Person("Zazie", "Beetz")
        ).collect(Collectors.toList());

        List<Movie> movies = Stream.of(
                new Movie(
                        123,
                        "Once upon a time in Hollywood",
                        Genre.COMEDY,
                        161,
                        new Person("Quentin", "Tarantino"),
                        actorsHollywood,
                        LocalDate.of(2019, Month.JULY, 25),
                        new Person("Milica", "Krmpotic")),
                new Movie(
                        321,
                        "Joker",
                        Genre.DRAMA,
                        121,
                        new Person("Todd", "Philips"),
                        actorsJoker,
                        LocalDate.of(2019, Month.AUGUST, 31),
                        new Person("Gojko", "Mrnjavcevic"))
        ).collect(Collectors.toList());

        return new MovieStore("Arena", "Zagreb", movies);
    }

}
