/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package hr.algebra.io.binary;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;

import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author dnlbe
 */
public class Main {

    private static final String SOURCE = "assets/funny.jpeg";
    private static final String DESTINATION = "assets/funny_copy.jpeg";    
    private static final String BINARY = "assets/person.dat";
    
    public static void main(String[] args) {
            
        try {
            read(SOURCE);
            readBuffered(SOURCE);
            copy(SOURCE, DESTINATION);
            serialize(new Person(1, "Daniel", "Bele"), BINARY);
            System.out.println(deserialize(BINARY));
        } catch (IOException | ClassNotFoundException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private static void read(String path) throws IOException {
        // it does not throw exception - lazy
        File file = new File(path); 
        if (!file.exists()) {
            // no sense in creating a file here
            //file.createNewFile();
            return;
        }
        try (InputStream is = new FileInputStream(file)){
            int read;
            while ((read = is.read()) != -1) {
                System.out.println(read);
            }
        } 
    }

    private static void readBuffered(String path) throws IOException {
        try (InputStream is = new FileInputStream(path)){
            byte[] buffer = new byte[1024];
            while ((is.read(buffer)) > 0) {
                System.out.println(new String(buffer));
            }
        } 
    }

    private static void copy(String source, String destination) throws IOException {
        try (InputStream is = new FileInputStream(source);
                OutputStream os = new FileOutputStream(destination)){

            byte[] buffer = new byte[1024];
            int length;
            while ((length = is.read(buffer)) > 0) {
                os.write(buffer, 0, length);
            }
        } 
    }
    
    private static void serialize(Person person, String path) throws IOException {
        try (ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(path))) {
            out.writeObject(person);
        }
    }
    private static Person deserialize(String path) throws IOException, ClassNotFoundException {
        try (ObjectInputStream in = new ObjectInputStream(new FileInputStream(path))) {
            return (Person)in.readObject();
        }
    }
    
    private static class Person implements Serializable{
        
        private static final long serialVersionUID = 2169900288781028418L;
        
        private final int id;
        private final String firstName;
        private final String lastName;  

        public Person(int id, String firstName, String lastName) {
            this.id = id;
            this.firstName = firstName;
            this.lastName = lastName;
        }

        @Override
        public String toString() {
            return "Person{" + "id=" + id + ", firstName=" + firstName + ", lastName=" + lastName + '}';
        }        
    }
}
