/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package hr.algebra.enums;

/**
 *
 * @author daniel.bele
 */
public enum FinalOperation {
    PLUS("+") {
        @Override
        double apply(double a, double b) {
            return a + b;
        }
    }, 
    MINUS("-"){
        @Override
        double apply(double a, double b) {
            return a - b;
        }
    },
    TIMES("*"){
        @Override
        double apply(double a, double b) {
            return a * b;
        }
    },
    DIVIDE("/"){
        @Override
        double apply(double a, double b) {
            return b == 0 ? 0 : a / b;
        }
    };
    
    // we embed symbol into the Operation! 
    private final String symbol;

    private FinalOperation(String symbol) {
        this.symbol = symbol;
    }

    @Override
    public String toString() {
        return symbol;
    }
    
    abstract double apply(double a, double b);
}