/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package hr.algebra.model;

/**
 *
 * @author dnlbe
 */
// final class - prevent subclassing
public final  class Item {
    
    private static int ID_GEN;
    
    private final int id;
    private String title;
    private String description;
    private double price;
    private int pieces;
    private String imagePath;

    public Item(String title, String description, double price, int pieces, String imagePath) {
        id = ++ID_GEN;
        this.title = title;
        this.description = description;
        this.price = price;
        this.pieces = pieces;
        this.imagePath = imagePath;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public double getPrice() {
        return price;
    }

    public void setPrice(double price) {
        this.price = price;
    }

    public int getPieces() {
        return pieces;
    }

    public void setPieces(int pieces) {
        this.pieces = pieces;
    }

    public String getImagePath() {
        return imagePath;
    }

    public void setImagePath(String imagePath) {
        this.imagePath = imagePath;
    }

    @Override
    public String toString() {
        return title;
    }

    @Override
    public int hashCode() {
        return Integer.valueOf(id).hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if(obj instanceof Item) {
            return id == ((Item)obj).id;
        }
        return false;
    }
    
}
