/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package hr.algebra.view;

import hr.algebra.model.AuthorTransferable;
import hr.algebra.model.Author;
import hr.algebra.model.AuthorAddable;
import hr.algebra.model.Paper;
import hr.algebra.model.PaperArchive;
import hr.algebra.model.PaperType;
import hr.algebra.utilities.JAXBUtils;
import hr.algebra.utilities.MessageUtils;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.TransferHandler;

/**
 *
 * @author dnlbe
 */
public class PaperManager extends javax.swing.JFrame implements AuthorAddable{

    private static final String FILENAME = "src/main/resources/paperarchive.xml";

    private List<JTextField> validationFields;
    private List<JLabel> errorLabels;

    private final Set<Author> allAuthors = new TreeSet<>();
    private final Set<Author> authors = new TreeSet<>();
    private final List<Paper> papers = new ArrayList<>();

    private final DefaultListModel<Author> allAuthorsModel = new DefaultListModel<>();
    private final DefaultListModel<Author> authorsModel = new DefaultListModel<>();
    private final DefaultListModel<Paper> papersModel = new DefaultListModel<>();

    /**
     * Creates new form PaperManager
     */
    public PaperManager() {
        initComponents();
        init();
        loadPapersAndAuthors();
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane1 = new javax.swing.JScrollPane();
        lsAuthors = new javax.swing.JList<>();
        jLabel2 = new javax.swing.JLabel();
        tfTitle = new javax.swing.JTextField();
        jLabel3 = new javax.swing.JLabel();
        jLabel4 = new javax.swing.JLabel();
        tfPublishedDate = new javax.swing.JTextField();
        jLabel5 = new javax.swing.JLabel();
        lbTitleError = new javax.swing.JLabel();
        jScrollPane2 = new javax.swing.JScrollPane();
        lsAllAuthors = new javax.swing.JList<>();
        jScrollPane3 = new javax.swing.JScrollPane();
        lsPapers = new javax.swing.JList<>();
        jLabel10 = new javax.swing.JLabel();
        jLabel11 = new javax.swing.JLabel();
        btnSavePapers = new javax.swing.JButton();
        btnAddAuthor = new javax.swing.JButton();
        btnAddPaper = new javax.swing.JButton();
        btnRefreshPapers = new javax.swing.JButton();
        cbPaperTypes = new javax.swing.JComboBox<>();
        lbPublishedDateError = new javax.swing.JLabel();
        lbAuthorsError = new javax.swing.JLabel();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("Papers");

        jScrollPane1.setViewportView(lsAuthors);

        jLabel2.setText("Title");

        jLabel3.setText("Type");

        jLabel4.setText("Published date (yyyy-MM-dd)");

        tfPublishedDate.setName("Date"); // NOI18N

        jLabel5.setText("Papers");

        lbTitleError.setForeground(new java.awt.Color(255, 0, 0));
        lbTitleError.setText("X");

        jScrollPane2.setViewportView(lsAllAuthors);

        jScrollPane3.setViewportView(lsPapers);

        jLabel10.setText("Authors");

        jLabel11.setText("All Authors");

        btnSavePapers.setText("Save Papers");
        btnSavePapers.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnSavePapersActionPerformed(evt);
            }
        });

        btnAddAuthor.setText("Add Author");
        btnAddAuthor.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnAddAuthorActionPerformed(evt);
            }
        });

        btnAddPaper.setText("Add Paper");
        btnAddPaper.setToolTipText("");
        btnAddPaper.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnAddPaperActionPerformed(evt);
            }
        });

        btnRefreshPapers.setText("Refresh Papers");
        btnRefreshPapers.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnRefreshPapersActionPerformed(evt);
            }
        });

        lbPublishedDateError.setForeground(new java.awt.Color(255, 0, 0));
        lbPublishedDateError.setText("X");

        lbAuthorsError.setForeground(new java.awt.Color(255, 0, 0));
        lbAuthorsError.setText("X");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel5)
                    .addComponent(jScrollPane3, javax.swing.GroupLayout.PREFERRED_SIZE, 159, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(btnSavePapers, javax.swing.GroupLayout.PREFERRED_SIZE, 342, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(btnAddAuthor, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addGroup(layout.createSequentialGroup()
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addGroup(layout.createSequentialGroup()
                                        .addComponent(tfTitle, javax.swing.GroupLayout.PREFERRED_SIZE, 161, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                        .addComponent(lbTitleError, javax.swing.GroupLayout.PREFERRED_SIZE, 12, javax.swing.GroupLayout.PREFERRED_SIZE))
                                    .addComponent(jLabel2)
                                    .addGroup(layout.createSequentialGroup()
                                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                                            .addComponent(jLabel3)
                                            .addComponent(jLabel4)
                                            .addComponent(tfPublishedDate)
                                            .addComponent(cbPaperTypes, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                        .addComponent(lbPublishedDateError, javax.swing.GroupLayout.PREFERRED_SIZE, 12, javax.swing.GroupLayout.PREFERRED_SIZE)))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 159, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(jLabel10)))
                            .addComponent(btnAddPaper, javax.swing.GroupLayout.PREFERRED_SIZE, 342, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(btnRefreshPapers, javax.swing.GroupLayout.PREFERRED_SIZE, 342, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(lbAuthorsError, javax.swing.GroupLayout.PREFERRED_SIZE, 12, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel11)
                            .addComponent(jScrollPane2, javax.swing.GroupLayout.PREFERRED_SIZE, 159, javax.swing.GroupLayout.PREFERRED_SIZE))))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {btnAddAuthor, jScrollPane2});

        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel2)
                    .addComponent(jLabel5)
                    .addComponent(jLabel10)
                    .addComponent(jLabel11))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jScrollPane3)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(layout.createSequentialGroup()
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                                        .addGroup(layout.createSequentialGroup()
                                            .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                                .addComponent(tfTitle, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                                .addComponent(lbTitleError, javax.swing.GroupLayout.PREFERRED_SIZE, 12, javax.swing.GroupLayout.PREFERRED_SIZE))
                                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                                            .addComponent(jLabel3)
                                            .addGap(9, 9, 9)
                                            .addComponent(cbPaperTypes, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                                            .addComponent(jLabel4)
                                            .addGap(8, 8, 8)
                                            .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                                .addComponent(tfPublishedDate, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                                .addComponent(lbPublishedDateError, javax.swing.GroupLayout.PREFERRED_SIZE, 12, javax.swing.GroupLayout.PREFERRED_SIZE)))
                                        .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 0, Short.MAX_VALUE))
                                    .addComponent(lbAuthorsError, javax.swing.GroupLayout.PREFERRED_SIZE, 12, javax.swing.GroupLayout.PREFERRED_SIZE))
                                .addGap(18, 18, 18)
                                .addComponent(btnAddPaper, javax.swing.GroupLayout.PREFERRED_SIZE, 39, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addGap(18, 18, 18)
                                .addComponent(btnRefreshPapers, javax.swing.GroupLayout.PREFERRED_SIZE, 39, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addGap(0, 4, Short.MAX_VALUE))
                            .addComponent(jScrollPane2))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(btnAddAuthor, javax.swing.GroupLayout.PREFERRED_SIZE, 39, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(btnSavePapers, javax.swing.GroupLayout.PREFERRED_SIZE, 39, javax.swing.GroupLayout.PREFERRED_SIZE))))
                .addContainerGap())
        );

        pack();
        setLocationRelativeTo(null);
    }// </editor-fold>//GEN-END:initComponents

    private void btnAddAuthorActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnAddAuthorActionPerformed
        new AuthorDialog(this, false).setVisible(true);
    }//GEN-LAST:event_btnAddAuthorActionPerformed

    private void btnAddPaperActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnAddPaperActionPerformed
        if (formValid()) {
            Paper paper = new Paper(
                    new TreeSet<>(authors),
                    tfTitle.getText().trim(),
                    (PaperType) cbPaperTypes.getSelectedItem(),
                    LocalDate.parse(tfPublishedDate.getText().trim(), Paper.DATE_FORMATTER));
            papers.add(paper);
            loadPapersModel();
            clearForm();
        }
    }//GEN-LAST:event_btnAddPaperActionPerformed

    private void btnRefreshPapersActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnRefreshPapersActionPerformed
        loadPapersAndAuthors();
    }//GEN-LAST:event_btnRefreshPapersActionPerformed

    private void btnSavePapersActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnSavePapersActionPerformed
        try {
            JAXBUtils.save(new PaperArchive(papers), FILENAME);
            MessageUtils.showInformationMessage("Info", "Papers saved");
        } catch (Exception ex) {
            MessageUtils.showErrorMessage("Error", "Unable to save papers");
            Logger.getLogger(PaperManager.class.getName()).log(Level.SEVERE, null, ex);
        }
    }//GEN-LAST:event_btnSavePapersActionPerformed

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        /* Set the Nimbus look and feel */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html 
         */
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(PaperManager.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(PaperManager.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(PaperManager.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(PaperManager.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>
        //</editor-fold>
        //</editor-fold>
        //</editor-fold>

        /* Create and display the form */
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new PaperManager().setVisible(true);
            }
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnAddAuthor;
    private javax.swing.JButton btnAddPaper;
    private javax.swing.JButton btnRefreshPapers;
    private javax.swing.JButton btnSavePapers;
    private javax.swing.JComboBox<PaperType> cbPaperTypes;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JLabel lbAuthorsError;
    private javax.swing.JLabel lbPublishedDateError;
    private javax.swing.JLabel lbTitleError;
    private javax.swing.JList<Author> lsAllAuthors;
    private javax.swing.JList<Author> lsAuthors;
    private javax.swing.JList<Paper> lsPapers;
    private javax.swing.JTextField tfPublishedDate;
    private javax.swing.JTextField tfTitle;
    // End of variables declaration//GEN-END:variables

    private void init() {
        initValidation();
        hideErrors();
        loadPaperTypesModel();
        initDragNDrop();
    }

    private void initValidation() {
        validationFields = Arrays.asList(tfTitle, tfPublishedDate);
        errorLabels = Arrays.asList(lbTitleError, lbPublishedDateError);
    }

    private void hideErrors() {
        errorLabels.forEach(e -> e.setVisible(false));
        lbAuthorsError.setVisible(false);
    }
    private void loadPaperTypesModel() {
        cbPaperTypes.setModel(new DefaultComboBoxModel<>(PaperType.values()));
    }

    private void loadAllAuthorsModel() {
        allAuthorsModel.clear();
        allAuthors.forEach(allAuthorsModel::addElement);
        lsAllAuthors.setModel(allAuthorsModel);
    }

    private void loadAuthorsModel() {
        authorsModel.clear();
        authors.forEach(authorsModel::addElement);
        lsAuthors.setModel(authorsModel);
    }

    private void loadPapersModel() {
        papersModel.clear();
        papers.forEach(papersModel::addElement);
        lsPapers.setModel(papersModel);
    }

    private void initDragNDrop() {
        lsAllAuthors.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        lsAllAuthors.setDragEnabled(true);
        lsAllAuthors.setTransferHandler(new ExportTransferHandler());

        lsAuthors.setDropMode(DropMode.ON);
        lsAuthors.setTransferHandler(new ImportTransferHandler());
    }

    private void loadPapersAndAuthors() {
        try {
            PaperArchive paperArchive = (PaperArchive) JAXBUtils.load(PaperArchive.class, FILENAME);
            papers.clear();
            papers.addAll(paperArchive.getPapers());
            allAuthors.clear();
            papers.forEach(paper -> allAuthors.addAll(paper.getAuthors()));
            loadPapersModel();
            loadAllAuthorsModel();

        } catch (Exception ex) {
            MessageUtils.showErrorMessage("Error", "Unable to load papers");
            Logger.getLogger(PaperManager.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private class ExportTransferHandler extends TransferHandler {

        @Override
        public int getSourceActions(JComponent c) {
            return COPY;
        }

        @Override
        public Transferable createTransferable(JComponent c) {
            return new AuthorTransferable(lsAllAuthors.getSelectedValue());
        }
    }

    private class ImportTransferHandler extends TransferHandler {

        @Override
        public boolean canImport(TransferSupport support) {
            return support.isDataFlavorSupported(AuthorTransferable.AUTHOR_FLAVOR);
        }

        @Override
        public boolean importData(TransferSupport support) {
            Transferable transferable = support.getTransferable();
            try {
                Author add = (Author) transferable.getTransferData(AuthorTransferable.AUTHOR_FLAVOR);
                if (authors.add(add)) {
                    loadAuthorsModel();
                    return true;
                }
            } catch (UnsupportedFlavorException | IOException ex) {
                Logger.getLogger(PaperManager.class.getName()).log(Level.SEVERE, null, ex);
            }
            return false;
        }
    }

    private boolean formValid() {
        hideErrors();
        boolean ok = true;

        for (int i = 0; i < validationFields.size(); i++) {
            ok &= !validationFields.get(i).getText().trim().isEmpty();
            errorLabels.get(i).setVisible(validationFields.get(i).getText().trim().isEmpty());

            if ("Date".equals(validationFields.get(i).getName())) {
                try {
                    LocalDate.parse(validationFields.get(i).getText().trim(), Paper.DATE_FORMATTER);
                } catch (Exception e) {
                    ok = false;
                    errorLabels.get(i).setVisible(true);
                }
            }
        }
        if (lsAuthors.getModel().getSize() == 0) {
            lbAuthorsError.setVisible(true);
            ok = false;
        }

        return ok;
    }

    private void clearForm() {
        hideErrors();
        validationFields.forEach(e -> e.setText(""));
        authorsModel.clear();
        authors.clear();
        cbPaperTypes.setSelectedIndex(0);
        lsAllAuthors.clearSelection();
    }

    @Override
    public boolean addAuthor(Author author) {
        if (allAuthors.add(author)) {
            loadAllAuthorsModel();
            return true;
        }
        return false;
    }

}
