/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package hr.algebra.view;

import hr.algebra.utilities.FileUtils;
import hr.algebra.utilities.MessageUtils;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;

/**
 *
 * @author dnlbe
 */
public class Notepad extends javax.swing.JFrame {

    private Optional<File> selectedFile = Optional.empty();
    private boolean edited;
    private static final String DATE_FORMAT = "hh:mm dd.MM.yyyy.";

    /**
     * Creates new form Notepad
     */
    public Notepad() {
        initComponents();
        handleEditMenu();
        handleLookAndFeel();
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane1 = new javax.swing.JScrollPane();
        tpContent = new javax.swing.JTextPane();
        jMenuBar1 = new javax.swing.JMenuBar();
        menuFile = new javax.swing.JMenu();
        miNew = new javax.swing.JMenuItem();
        miOpen = new javax.swing.JMenuItem();
        miSave = new javax.swing.JMenuItem();
        miSaveAs = new javax.swing.JMenuItem();
        jSeparator1 = new javax.swing.JPopupMenu.Separator();
        miPageSetup = new javax.swing.JMenuItem();
        miPrint = new javax.swing.JMenuItem();
        jSeparator2 = new javax.swing.JPopupMenu.Separator();
        miExit = new javax.swing.JMenuItem();
        menuEdit = new javax.swing.JMenu();
        menuView = new javax.swing.JMenu();
        menuLF = new javax.swing.JMenu();
        menuHelp = new javax.swing.JMenu();
        miAbout = new javax.swing.JMenuItem();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("Notepad");
        getContentPane().setLayout(new javax.swing.BoxLayout(getContentPane(), javax.swing.BoxLayout.LINE_AXIS));

        jScrollPane1.setPreferredSize(new java.awt.Dimension(800, 600));

        tpContent.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                tpContentKeyReleased(evt);
            }
        });
        jScrollPane1.setViewportView(tpContent);

        getContentPane().add(jScrollPane1);

        menuFile.setMnemonic('F');
        menuFile.setText("File");

        miNew.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_N, java.awt.event.InputEvent.CTRL_DOWN_MASK));
        miNew.setText("New");
        miNew.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                miNewActionPerformed(evt);
            }
        });
        menuFile.add(miNew);

        miOpen.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_O, java.awt.event.InputEvent.CTRL_DOWN_MASK));
        miOpen.setText("Open...");
        miOpen.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                miOpenActionPerformed(evt);
            }
        });
        menuFile.add(miOpen);

        miSave.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_S, java.awt.event.InputEvent.CTRL_DOWN_MASK));
        miSave.setText("Save");
        miSave.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                miSaveActionPerformed(evt);
            }
        });
        menuFile.add(miSave);

        miSaveAs.setText("Save As...");
        miSaveAs.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                miSaveAsActionPerformed(evt);
            }
        });
        menuFile.add(miSaveAs);
        menuFile.add(jSeparator1);

        miPageSetup.setText("Page Setup");
        miPageSetup.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                miPageSetupActionPerformed(evt);
            }
        });
        menuFile.add(miPageSetup);

        miPrint.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_P, java.awt.event.InputEvent.CTRL_DOWN_MASK));
        miPrint.setText("Print");
        miPrint.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                miPrintActionPerformed(evt);
            }
        });
        menuFile.add(miPrint);
        menuFile.add(jSeparator2);

        miExit.setText("Exit");
        miExit.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                miExitActionPerformed(evt);
            }
        });
        menuFile.add(miExit);

        jMenuBar1.add(menuFile);

        menuEdit.setMnemonic('E');
        menuEdit.setText("Edit");
        jMenuBar1.add(menuEdit);

        menuView.setMnemonic('V');
        menuView.setText("View");

        menuLF.setMnemonic('L');
        menuLF.setText("Look and feel");
        menuView.add(menuLF);

        jMenuBar1.add(menuView);

        menuHelp.setMnemonic('H');
        menuHelp.setText("Help");

        miAbout.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_A, java.awt.event.InputEvent.SHIFT_DOWN_MASK | java.awt.event.InputEvent.CTRL_DOWN_MASK));
        miAbout.setText("About");
        miAbout.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                miAboutActionPerformed(evt);
            }
        });
        menuHelp.add(miAbout);

        jMenuBar1.add(menuHelp);

        setJMenuBar(jMenuBar1);

        pack();
        setLocationRelativeTo(null);
    }// </editor-fold>//GEN-END:initComponents

    private void miSaveAsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_miSaveAsActionPerformed
        try {
            selectedFile = FileUtils.saveTextInFile(tpContent.getText(), Optional.empty());
            edited = false;
        } catch (IOException ex) {
            Logger.getLogger(Notepad.class.getName()).log(Level.SEVERE, null, ex);
        }
    }//GEN-LAST:event_miSaveAsActionPerformed

    private void miSaveActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_miSaveActionPerformed
        try {
            selectedFile = FileUtils.saveTextInFile(tpContent.getText(), selectedFile);
            edited = false;
        } catch (IOException ex) {
            Logger.getLogger(Notepad.class.getName()).log(Level.SEVERE, null, ex);
        }
    }//GEN-LAST:event_miSaveActionPerformed

    private void tpContentKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_tpContentKeyReleased
        edited = true;
    }//GEN-LAST:event_tpContentKeyReleased

    private void miOpenActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_miOpenActionPerformed
        try {
            Optional<String> optText = FileUtils.loadTextFromFile();
            if (optText.isPresent()) {
                tpContent.setText(optText.get());
                edited = false;
                selectedFile = Optional.empty();
            }
        } catch (IOException ex) {
            Logger.getLogger(Notepad.class.getName()).log(Level.SEVERE, null, ex);
        }
    }//GEN-LAST:event_miOpenActionPerformed

    private void miNewActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_miNewActionPerformed
        if (edited) {
            miSaveAs.doClick();
        }
        tpContent.setText("");
        selectedFile = Optional.empty();
    }//GEN-LAST:event_miNewActionPerformed

    private void miPageSetupActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_miPageSetupActionPerformed
        PrinterJob job = PrinterJob.getPrinterJob();
        PageFormat format = job.pageDialog(job.defaultPage());
        try {
            job.print();
        } catch (PrinterException ex) {
            Logger.getLogger(Notepad.class.getName()).log(Level.SEVERE, null, ex);
        }
    }//GEN-LAST:event_miPageSetupActionPerformed

    private void miPrintActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_miPrintActionPerformed
        PrinterJob job = PrinterJob.getPrinterJob();
        if (job.printDialog()) {
            try {
                job.print();
            } catch (PrinterException ex) {
                Logger.getLogger(Notepad.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }//GEN-LAST:event_miPrintActionPerformed

    private void miExitActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_miExitActionPerformed
        if (edited) {
            miSaveAs.doClick();
        }
        dispose();
    }//GEN-LAST:event_miExitActionPerformed

    private void miAboutActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_miAboutActionPerformed
        MessageUtils.showInformationMessage("Notepad", "This is a simple notepad");
    }//GEN-LAST:event_miAboutActionPerformed

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        /* Set the Nimbus look and feel */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html 
         */
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException | InstantiationException | IllegalAccessException | javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(Notepad.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>
        //</editor-fold>
        //</editor-fold>
        //</editor-fold>

        //</editor-fold>

        /* Create and display the form */
        java.awt.EventQueue.invokeLater(() -> {
            JFrame frame = new Notepad();
            frame.setLocationRelativeTo(null);
            frame.setVisible(true);
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JMenuBar jMenuBar1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JPopupMenu.Separator jSeparator1;
    private javax.swing.JPopupMenu.Separator jSeparator2;
    private javax.swing.JMenu menuEdit;
    private javax.swing.JMenu menuFile;
    private javax.swing.JMenu menuHelp;
    private javax.swing.JMenu menuLF;
    private javax.swing.JMenu menuView;
    private javax.swing.JMenuItem miAbout;
    private javax.swing.JMenuItem miExit;
    private javax.swing.JMenuItem miNew;
    private javax.swing.JMenuItem miOpen;
    private javax.swing.JMenuItem miPageSetup;
    private javax.swing.JMenuItem miPrint;
    private javax.swing.JMenuItem miSave;
    private javax.swing.JMenuItem miSaveAs;
    private javax.swing.JTextPane tpContent;
    // End of variables declaration//GEN-END:variables

    private void handleEditMenu() {

        //List<Action> actions = Arrays.asList(tpContent.getActions());
        //actions.forEach(action -> System.out.println(action.getValue(Action.NAME)));
        //Map<String, Action> actionMap = actions.stream().collect(Collectors.toMap(a -> (String) a.getValue(Action.NAME), a -> a));

        ActionMap actionMap = tpContent.getActionMap();
        
        /*
        JMenuItem miCut = new JMenuItem();   
        miCut.setAction(actionMap.get(DefaultEditorKit.cutAction));
        miCut.setText("Cut");
        miCut.setAccelerator(KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_X, java.awt.event.InputEvent.CTRL_MASK));
        menuEdit.add(miCut);
         */
        menuEdit.add(createMenuItem(
                actionMap.get(DefaultEditorKit.cutAction),
                "Cut",
                KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_X, java.awt.event.InputEvent.CTRL_MASK))
        );

        menuEdit.add(createMenuItem(
                actionMap.get(DefaultEditorKit.copyAction),
                "Copy",
                KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_C, java.awt.event.InputEvent.CTRL_MASK))
        );

        menuEdit.add(createMenuItem(
                actionMap.get(DefaultEditorKit.pasteAction),
                "Paste",
                KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_V, java.awt.event.InputEvent.CTRL_MASK))
        );

        menuEdit.addSeparator();

        menuEdit.add(createMenuItem(
                actionMap.get(DefaultEditorKit.selectAllAction),
                "Select All",
                KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_A, java.awt.event.InputEvent.CTRL_MASK))
        );

        
        JMenuItem miTimeDate = createMenuItem(
                null,
                "Time/Date",
                KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_F5, 0)
        );
        miTimeDate.addActionListener(e -> {
            try {
                tpContent.getDocument().insertString(
                        tpContent.getCaretPosition(),
                        LocalDateTime.now().format(DateTimeFormatter.ofPattern(DATE_FORMAT)),
                        null);
            } catch (BadLocationException ex) {
                Logger.getLogger(Notepad.class.getName()).log(Level.SEVERE, null, ex);
            }
        });
        menuEdit.add(miTimeDate);
    }

    private void handleLookAndFeel() {
        ButtonGroup bgLookFeel = new ButtonGroup();
        Arrays.asList(UIManager.getInstalledLookAndFeels()).forEach(lf -> {
            JRadioButtonMenuItem mi = new JRadioButtonMenuItem(lf.getName());
            bgLookFeel.add(mi);
            menuLF.add(mi);
            if ("Nimbus".equals(lf.getName())) {
                mi.setSelected(true);
            }
            mi.addActionListener(e -> {
                try {
                    UIManager.setLookAndFeel(lf.getClassName());
                    SwingUtilities.updateComponentTreeUI(Notepad.this);
                } catch (ClassNotFoundException | InstantiationException | IllegalAccessException | UnsupportedLookAndFeelException ex) {
                    Logger.getLogger(Notepad.class.getName()).log(Level.SEVERE, null, ex);
                }
            });
        });
    }

    private JMenuItem createMenuItem(Action action, String text, KeyStroke accelerator) {
        JMenuItem menuItem = new JMenuItem();
        menuItem.setAction(action);
        menuItem.setText(text);
        menuItem.setAccelerator(accelerator);
        return menuItem;
    }
}
