/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package hr.algebra.model;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;


/**
 *
 * @author dnlbe
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(propOrder = {"title", "paperType", "publishedDate", "authors"})
public class Paper {

    public static DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ISO_DATE;
    
    @XmlElementWrapper
    @XmlElement(name = "author")
    private Set<Author> authors;
    private String title;
    @XmlElement(name = "papertype")
    private PaperType paperType;  
    
    @XmlJavaTypeAdapter(PublishedDateAdapter.class)
    @XmlElement(name = "publisheddate")
    private LocalDate publishedDate;
    
    public Paper() {
    }
    
    public Paper(Set<Author> authors, String title, PaperType paperType, LocalDate publishedDate) {
        this.authors = authors;
        this.title = title;
        this.paperType = paperType;
        this.publishedDate = publishedDate;
    }

    public Set<Author> getAuthors() {
        return authors;
    }

    @Override
    public String toString() {
        return title;
    }
    
}
