/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package hr.algebra.enums;

/**
 *
 * @author dnlbe
 */
public enum Operation {
    PLUS("+"), 
    MINUS("-"), 
    TIMES("*"), 
    DIVIDE("/");
    
    // we embed symbol into the Operation! 
    private final String symbol;

    private Operation(String symbol) {
        this.symbol = symbol;
    }
    
    // the burden of changes is now on the source of the change!
    double apply(double a, double b) {
        switch (this) {
            case PLUS: return a + b;
            case MINUS: return a - b;
            case TIMES: return a * b;
            case DIVIDE: return b !=0 ? a / b : 0;
        }
        throw new RuntimeException("No such method");
    }

    @Override
    public String toString() {
        return symbol;
    }
}
