/*
 * Click nbfs://nbhost/SystemFileSystem/Templates/Licenses/license-default.txt to change this license
 * Click nbfs://nbhost/SystemFileSystem/Templates/Classes/Class.java to edit this template
 */
package hr.algebra.model;

public abstract class Vehicle implements Comparable<Vehicle> {

    private static int ID_GENERATOR;

    private final int id;

    public Vehicle() {
        id = ++ID_GENERATOR;
    }

    public abstract void drive();

    public abstract void stop();

    public int getId() {
        return id;
    }

    @Override
    public int hashCode() {
        return Integer.valueOf(id).hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Vehicle other) {
            return id == other.id;
        }
        return false;
    }

    @Override
    public int compareTo(Vehicle o) {
        return Integer.valueOf(id).compareTo(o.id);
    }

    @Override
    public String toString() {
        return "Vehicle{" + "id=" + id + '}';
    }
}
