/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package hr.algebra.enums;

/**
 *
 * @author dnlbe
 */
public class LazyElvis {

    private LazyElvis() {
        init();
    }

    private void init() {
        System.out.println("You only pass through this life once, you don't come back for an encore.");
    }
    
    public void makeTeensScream(double andTheirMomsToo) { }
    
    // in multithreaded environment, threads can cache locally instances of Singleton
    // since LazyElvis could have a mutable state (our does not), one thread could change the state of his cached Singleton, 
    // and the other thread would not see the Singleton with the changed state, but locally cached Singleton with an old state!
    // solution -> volatile keyboard: every read/write will be from/in main memory, and not CPU cache
    private static volatile LazyElvis instance;  

    public static LazyElvis getInstance() {
        LazyElvis instance = LazyElvis.instance;
        if (instance == null) {
            // synchronized internally creates a monitor -> we use class instance variable as a monitor
            // since there is only one class instance (the object representing the class metadata at runtime) 
            // only one thread can be in this block:
            synchronized (LazyElvis.class) {
                instance = LazyElvis.instance;
                // double checked locking - another thread could have created the instance in the meantime
                if (instance == null) { 
                    LazyElvis.instance = instance = new LazyElvis();
                }
            }
            // this is far too complicated scenario! - we need an eager Singleton!
        }
        return instance;
    }
}
