/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package hr.algebra.io.character;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author dnlbe
 */
public class Main {
    
    private static final String SOURCE = "assets/quotes.txt";
    private static final String DESTINATION = "assets/quotes_copy.txt";
    private static final String URI = "https://www.qq.com"; // encoding in header
    
    public static void main(String[] args) {

         try {
            copy(SOURCE, DESTINATION);
            copyBuffered(SOURCE, DESTINATION);
            readBuffered(System.in, "|");
            readBuffered(new FileInputStream(SOURCE), ",");
            readUri(URI, Charset.forName("GB2312")); //StandardCharsets.ISO_8859_1, StandardCharsets.UTF_8, StandardCharsets.UTF_16 
            
        } catch (IOException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
    
    
    private static void copy(String source, String destination) throws IOException {
        try (Reader reader = new FileReader(source);
                /*Writer writer = new FileWriter(destination)){*/
                // decorator pattern
                Writer writer = new PrintWriter(new FileWriter(destination))){

            char[] buffer = new char[1024];
            int length;
            while ((length = reader.read(buffer)) > 0) {
                writer.write(buffer, 0, length);
            }
        } 
    }

    private static void copyBuffered(String source, String destination) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(source), 1024);
                BufferedWriter writer = new BufferedWriter(new FileWriter(destination))) {
            
            String line;
            while ((line = reader.readLine()) != null) {
                //System.out.println(line);
                writer.write(line);
                writer.write(System.lineSeparator());
            }        
        }
    }
    
    private static void readBuffered(InputStream in, String end) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in))){
            String line;
            while ((line = reader.readLine()) != null && !line.contains(end)) {
                System.out.println(line);
            }
        } 
    }

    private static void readUri(String uri, Charset charset) throws MalformedURLException, IOException {
        URL url = new URL(uri);
        URLConnection con = url.openConnection();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(con.getInputStream(), charset))) {
            reader.lines().forEach(System.out::println);
        }
    }
}
