/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package hr.algebra.nio;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

/**
 *
 * @author dnlbe
 */
public class Main {
    
    private static final String SOURCE = "assets/quotes.txt";
    private static final String DESTINATION = "assets/qoutes_copy.txt";
    private static final String DIR = ".";
    
    public static void main(String[] args) {
                   
         try {            
            streamLines(SOURCE);
            Files.readAllLines(Paths.get(SOURCE)).forEach(System.out::println);
            Files.copy(Paths.get(SOURCE), Paths.get(DESTINATION), StandardCopyOption.REPLACE_EXISTING);
            listContentsOfDirectory(DIR);
            walkThroughDirectories(DIR);
            printContents(DIR, "Main.java");
         } catch (IOException ex) {
             Logger.getLogger(Main.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
         }

    }

    private static void streamLines(String source) throws IOException {
        Path path = Paths.get(source);        
        // easy to convert
        //File file = path.toFile();
        // and vice versa
        //path = file.toPath();
        if(!Files.exists(path)) {
            // no sense in creating a file here
            //Files.createFile(path);
            return;
        }
        // .lines(Path) does not closes the stream!!! we must do it manually!
        try(Stream<String> lines = Files.lines(path)) {
            lines.forEach(System.out::println);            
        }
    }
    
    private static void listContentsOfDirectory(String path) throws IOException {
        try(Stream<Path> list = Files.list(Paths.get(path))) {
            list.forEach(System.out::println);
        }
    }

    private static void walkThroughDirectories(String path) throws IOException {
        try(Stream<Path> list = Files.walk(Paths.get(path))) {
            list.forEach(System.out::println);
        }
    }

    private static void printContents(String path, String filename) throws IOException {
        Path rootPath = Paths.get(path);
        Files.walkFileTree(rootPath, new SimpleFileVisitor<Path>() {
            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (file.endsWith(filename)) {
                    System.out.println(file.toAbsolutePath());
                    streamLines(file.toString());
                    return FileVisitResult.TERMINATE;                    
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }
}
