/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package hr.algebra.enums;

/**
 *
 * @author dnlbe
 */
public class EnumMain {
    
    public static void main(String[] args) {
        double a = 1.2;
        double b = 2.4;
        simpleOperations(a, b);
        operations(a, b);
        finalOperations(a, b);
        
    }

    private static void simpleOperations(double a, double b) {
        System.out.println("Simple operations");
        for (SimpleOperation op : SimpleOperation.values()) {
            applySimpleOperation(a, b, op);            
        }
    }

    // we have numerous problems here:
    // 1. what if we add some operation into Enum? - then all the clients must change their code accordingly
    //      - can we move this burden from the client onto the Enum?
    // 2. we always need to print the symbol for different operations - can we fix that also?
    private static void applySimpleOperation(double a, double b, SimpleOperation op) {
        switch (op) {
            case PLUS -> System.out.printf("%.2f + %.2f = %.2f%n", a, b, a + b);
            case MINUS -> System.out.printf("%.2f - %.2f = %.2f%n", a, b, a - b);
            case TIMES -> System.out.printf("%.2f * %.2f = %.2f%n", a, b, a * b);
            case DIVIDE -> System.out.printf("%.2f / %.2f = %.2f%n", a, b, a / b);
        }
    }

    private static void operations(double a, double b) {
        System.out.println("Operations");
        for (Operation op : Operation.values()) {
                System.out.printf("%.2f %s %.2f = %.2f%n", a, op, b, op.apply(a, b));            
        }
    }
    
    private static void finalOperations(double a, double b) {
        System.out.println("Final operations");
        for (FinalOperation op : FinalOperation.values()) {
                System.out.printf("%.2f %s %.2f = %.2f%n", a, op, b, op.apply(a, b));            
        }
    }
}
