/*
 * Click nbfs://nbhost/SystemFileSystem/Templates/Licenses/license-default.txt to change this license
 * Click nbfs://nbhost/SystemFileSystem/Templates/GUIForms/JFrame.java to edit this template
 */
package hr.algebra;

import hr.algebra.model.Student;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultListModel;

/**
 *
 * @author lecturer
 */
public class Task02 extends javax.swing.JFrame {

    /**
     * Creates new form Task02
     */
    public Task02() {
        initComponents();
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        tfFirst = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        tfLast = new javax.swing.JTextField();
        jScrollPane1 = new javax.swing.JScrollPane();
        lsStudents = new javax.swing.JList<>();
        btnFnAsc = new javax.swing.JButton();
        btnFnDesc = new javax.swing.JButton();
        btnLnAsc = new javax.swing.JButton();
        btnLnDesc = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("Person sorter");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowOpened(java.awt.event.WindowEvent evt) {
                formWindowOpened(evt);
            }
        });

        jLabel1.setText("First name");

        tfFirst.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                Task02.this.keyReleased(evt);
            }
        });

        jLabel2.setText("Last name");

        tfLast.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                Task02.this.keyReleased(evt);
            }
        });

        jScrollPane1.setViewportView(lsStudents);

        btnFnAsc.setText("FN Asc");
        btnFnAsc.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnFnAscActionPerformed(evt);
            }
        });

        btnFnDesc.setText("FN Desc");
        btnFnDesc.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnFnDescActionPerformed(evt);
            }
        });

        btnLnAsc.setText("LN Asc");
        btnLnAsc.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnLnAscActionPerformed(evt);
            }
        });

        btnLnDesc.setText("LN Desc");
        btnLnDesc.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnLnDescActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(29, 29, 29)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jLabel2, javax.swing.GroupLayout.PREFERRED_SIZE, 106, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(tfLast, javax.swing.GroupLayout.PREFERRED_SIZE, 113, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jLabel1, javax.swing.GroupLayout.PREFERRED_SIZE, 106, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(tfFirst, javax.swing.GroupLayout.PREFERRED_SIZE, 113, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addGap(45, 45, 45)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(btnLnAsc)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(btnLnDesc))
                    .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                        .addGroup(layout.createSequentialGroup()
                            .addComponent(btnFnAsc)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(btnFnDesc))
                        .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 228, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap(73, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(31, 31, 31)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLabel1, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(tfFirst, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addGap(18, 18, 18)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLabel2, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(tfLast, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))))
                .addGap(26, 26, 26)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(btnFnAsc)
                    .addComponent(btnFnDesc))
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(btnLnAsc)
                    .addComponent(btnLnDesc))
                .addContainerGap(49, Short.MAX_VALUE))
        );

        pack();
        setLocationRelativeTo(null);
    }// </editor-fold>//GEN-END:initComponents

    private void formWindowOpened(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowOpened
       
        generateStudents();
        Collections.sort(students);
        setModel();
        
    }//GEN-LAST:event_formWindowOpened

    private void keyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_keyReleased
        setModel();
    }//GEN-LAST:event_keyReleased

    private void btnFnAscActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnFnAscActionPerformed
        Collections.sort(
                students, 
                (l, r) -> l.getFirstName().compareToIgnoreCase(r.getFirstName()));
        setModel();
    }//GEN-LAST:event_btnFnAscActionPerformed

    private void btnFnDescActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnFnDescActionPerformed
        Collections.sort(
                students, 
                (l, r) -> -l.getFirstName().compareToIgnoreCase(r.getFirstName()));
        setModel();
    }//GEN-LAST:event_btnFnDescActionPerformed

    private void btnLnAscActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnLnAscActionPerformed
        Collections.sort(
                students, 
                (l, r) -> l.getLastName().compareToIgnoreCase(r.getLastName()));
        setModel();
    }//GEN-LAST:event_btnLnAscActionPerformed

    private void btnLnDescActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnLnDescActionPerformed
        Collections.sort(
                students, 
                (l, r) -> -l.getLastName().compareToIgnoreCase(r.getLastName()));
        setModel();
    }//GEN-LAST:event_btnLnDescActionPerformed

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        /* Set the Nimbus look and feel */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html 
         */
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(Task02.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(Task02.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(Task02.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(Task02.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>

        /* Create and display the form */
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new Task02().setVisible(true);
            }
        });
    }
    
    private List<Student> students;
    private final DefaultListModel<Student> model = new DefaultListModel<>();

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnFnAsc;
    private javax.swing.JButton btnFnDesc;
    private javax.swing.JButton btnLnAsc;
    private javax.swing.JButton btnLnDesc;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JList<Student> lsStudents;
    private javax.swing.JTextField tfFirst;
    private javax.swing.JTextField tfLast;
    // End of variables declaration//GEN-END:variables

    private void generateStudents() {
        students = Arrays.asList(
                new Student("Milica", "Kamilica", 321),
                new Student("Milutin", "Kamilica", 312),
                new Student("Gojko", "Mrnjavcevic", 123),
                new Student("Robert", "MeDiro", 213),
                new Student("Gargamel", "Gibson", 231)
        );
    }

    private void setModel() {
        model.clear();
        students
                .stream()
                .filter(student -> {
                    boolean test = true;
                    test &= student
                            .getFirstName()
                            .toLowerCase()
                            .startsWith(tfFirst.getText().trim().toLowerCase());
                    
                    test &= student
                            .getLastName()
                            .toLowerCase()
                            .startsWith(tfLast.getText().trim().toLowerCase());
                    
                    
                    return test;
                })
                .forEach(model::addElement);
        lsStudents.setModel(model);
    }
}
